
/*
 * LDASTools frameCPP - A library implementing the LIGO/Virgo frame specification
 *
 * Copyright (C) 2018 California Institute of Technology
 *
 * LDASTools frameCPP is free software; you may redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 (GPLv2) of the
 * License or at your discretion, any later version.
 *
 * LDASTools frameCPP is distributed in the hope that it will be useful, but
 * without any warranty or even the implied warranty of merchantability
 * or fitness for a particular purpose. See the GNU General Public
 * License (GPLv2) for more details.
 *
 * Neither the names of the California Institute of Technology (Caltech),
 * The Massachusetts Institute of Technology (M.I.T), The Laser
 * Interferometer Gravitational-Wave Observatory (LIGO), nor the names
 * of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * You should have received a copy of the licensing terms for this
 * software included in the file LICENSE located in the top-level
 * directory of this package. If you did not, you can view a copy at
 * http://dcc.ligo.org/M1500244/LICENSE
 */

#ifndef SWIG__COMMON__FR_DECTOR_I
#define SWIG__COMMON__FR_DETECTOR_I

%module(package="LDAStools") frameCPP

%import "framecpp/Detectors.hh"

enum detector_location_type {
  DETECTOR_LOCATION_G1 = FrameCPP::DETECTOR_LOCATION_G1,
  DETECTOR_LOCATION_H1 = FrameCPP::DETECTOR_LOCATION_H1,
  DETECTOR_LOCATION_H2 = FrameCPP::DETECTOR_LOCATION_H2,
  DETECTOR_LOCATION_K1 = FrameCPP::DETECTOR_LOCATION_K1,
  DETECTOR_LOCATION_L1 = FrameCPP::DETECTOR_LOCATION_L1,
  DETECTOR_LOCATION_T1 = FrameCPP::DETECTOR_LOCATION_T1,
  DETECTOR_LOCATION_V1 = FrameCPP::DETECTOR_LOCATION_V1
};

const FrDetector& GetDetector( detector_location_type Location,
   			       const GPSTime& Time );

#endif /* SWIG__COMMON__FR_DECTOR_I */
