function(get_pub_sub_version result)
    file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/version.txt" lines)
    set(version "")
    foreach(line ${lines})
        string(FIND "${line}" "#" has_comment)
        if ("${has_comment}" EQUAL "-1")
            set(version "${line}")
            break()
        endif()
    endforeach()
    set(${result} "${version}" PARENT_SCOPE)
endfunction()

function(get_pub_sub_version_tag result)
    file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/version_tag.txt" lines)
    set(version "")
    foreach(line ${lines})
        string(FIND "${line}" "#" has_comment)
        if ("${has_comment}" EQUAL "-1")
            set(version "${line}")
            break()
        endif()
    endforeach()
    set(${result} "${version}" PARENT_SCOPE)
endfunction()

function(get_debian_version result)
    file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/debian/changelog" changelog_entry LIMIT_COUNT 1)
    string(REGEX MATCHALL "\\(.*\\)" file_version "${changelog_entry}")
    # extract the version from between the ()
    string(LENGTH "${file_version}" version_length)
    math(EXPR version_length "${version_length}-2")
    string(SUBSTRING "${file_version}" 1 ${version_length} version)
    # now strip off packaging revisions "-#"
    string(FIND "${version}" "-" dash_position)
    if (NOT ${dash_position} EQUAL -1)
        string(SUBSTRING "${version}" 0 "${dash_position}" version)
    endif()
    set(${result} "${version}" PARENT_SCOPE)
endfunction()