//
// Created by jonathan.hanks on 12/3/25.
//
#include "simple_http.hh"
#include <curl/curl.h>
#include <memory>
#include <stdexcept>

class CURLInit
{
    public:
    CURLInit()
    {
        curl_global_init( CURL_GLOBAL_DEFAULT );
    }
    ~CURLInit()
    {
        curl_global_cleanup();
    }
};

static CURLInit curl_init_{};

using CURL_ptr = std::unique_ptr<CURL, decltype(&curl_easy_cleanup)>;

namespace
{
    size_t
    null_write_data(char *ptr, size_t size, size_t nmemb, void* userdata)
    {
        return nmemb;
    }
}

CURL_ptr
new_request()
{
    CURL *c = curl_easy_init();
    if (c == nullptr)
    {
        throw std::runtime_error("curl_easy_init() failed");
    }
    return CURL_ptr( c, curl_easy_cleanup );
}


bool
ping_url(const std::string& url)
{
    const auto curl = new_request( );

    curl_easy_setopt(curl.get(), CURLOPT_URL, url.c_str( ) );
    curl_easy_setopt(curl.get(), CURLOPT_WRITEFUNCTION, null_write_data);

    const auto res = curl_easy_perform( curl.get() );

    return res == CURLE_OK;
}