//
// Created by jonathan.hanks on 8/15/25.
//

#ifndef DAQD_TRUNK_MBUF_INTERNAL_H
#define DAQD_TRUNK_MBUF_INTERNAL_H

#include <linux/mm_types.h>
#include "mbuf_kernel.h"

// forward definitions needed to keep warning noise down.

// defined in kvmem.c
void *rvmalloc(long size);
void rvfree(void *mem, long size);
int rvmmap(void *mem, unsigned long memsize, struct vm_area_struct *vma);
void rkfree(void *mem, long size);
int rkmmap(void *mem, unsigned long memsize, struct vm_area_struct *vma);
void *rkmalloc(int *msize, int suprt);

// defined in mbuf.c
int mmap_kmem(unsigned int i, struct vm_area_struct *vma);
enum MBUF_KERNEL_CODE mbuf_release_area_file(const char* name, struct file *file);
int mbuf_allocate_area_file(const char* name, unsigned int size, struct file *file);

#endif //DAQD_TRUNK_MBUF_INTERNAL_H