#include "sub_plugin_rmipc.hh"
#include "catch.hpp"

#include <iostream>

using DcuRate = cps_plugins::detail::DcuRate;

TEST_CASE("You can extract the dcu and rate from a model name if it is specified")
{
    struct TestCase
    {
        std::string input;
        DcuRate dcu_rate;
    };
    auto tests = std::vector<TestCase>{
        TestCase{
            "edc:52:16",
            DcuRate{"edc", 52, 16},
        },
        TestCase{
            "edc:53",
            DcuRate{"edc", 53, 16},
        },
        TestCase{
            "sus:42:1024",
            DcuRate{"sus", 42, 1024},
        },
    };
    for (const auto& test : tests)
    {
        auto actual = cps_plugins::detail::lookup_dcu_and_rate( test.input );
        REQUIRE(actual.name == test.dcu_rate.name);
        REQUIRE(actual.dcu_id == test.dcu_rate.dcu_id);
        REQUIRE(actual.rate == test.dcu_rate.rate);
    }
}
