#!/usr/bin/env perl

#//     \page feCodeGen feCodeGen.pl
#//     Documentation for feCodeGen.pl - Controls parsing of Matlab files and code generation.
#//

#// \n\n This script is invoked by the auto generated build/src/epics/util/Makefile. \n\n\n
use File::Path;
use File::Copy;
use File::Path qw(make_path);
use Cwd;
use JSON;

require "lib/SUM.pm";
require "lib/AND.pm";
require "lib/MULTIPLY.pm";
require "lib/DIVIDE.pm";
require "lib/SATURATE.pm";
require "lib/MUX.pm";
require "lib/DEMUX.pm";
require "lib/RelationalOperator.pm";
require "lib/Switch.pm";
require "lib/Gain.pm";
require "lib/Abs.pm";
require "lib/MATH.pm";
require "lib/Dac20.pm";
require "lib/DemodDecim16.pm";
require "lib/DemodDecim8.pm";
require "lib/DemodRotate16.pm";
require "lib/DemodRotate8.pm";
require "lib/DemodBand16.pm";
require "lib/DemodBand8.pm";
require "lib/DemodBand4.pm";
require "lib/DemodBand2.pm";
require "lib/DemodBand1.pm";
require "lib/Dac_common.pm";

#// \b REQUIRED \b ARGUMENTS: \n
#//	- Model file name with .mdl extension \n
#//	- Output file name (from Makefile, this is same name without .mdl extension.\n
#//	
#// Remaining arguments listed in code are optional and not normally used by RCG Makefile. \n\n

#// Environment Vars
#// Required:
#//     RCG_SRC_DIR      : The current advligorts src directory that shoudl be used by the build. This is set
#//                        by the top level Makefile when calling rtcds build.
#//     PERL5LIB         : This is set by the top level Makefile so that these scrips can find cdsParts
#//
#// Optional:
#//     SIMULATION_BUILD : Warning this should not be set in production systems. This argument enables the generation
#//                        of IPC entries from IPC RECEIVER parts. This is used by librts so it can build models
#//                        with IPC receivers, that have senders from other models.
#//
#//

# Normal call from Makefile is just first two args.

#//	
#// \b PRODUCTS: \n
#//	- C code 
#//		- C source file <em> (build/src/fe/model_name/model_name.c)</em>, representing user model parts and processing sequence.\n
#//		- C code Makefile <em>(build/fe/model_name/Makefile)</em>. \n
#//	- Header file <em>(build/src/include/model_name/model_name.h)</em>, containing data passing structure between real-time code and EPICS sequencer code. \n
#//	- EPICS channel list <em>(build/src/epics/fmseq/model_name)</em>, to be used later by <em>fmseq.pl</em> to produce EPICS products. Included in this file: \n
#//		- List of all filter modules \n
#//		- List of all EPICS channel names and types. \n
#//		- List of extra test points ie those not associated with Filter modules. \n
#//	- EPICS state code Makefile <em>(build/config/Makefile.model_nameepics) </em>
#//	- File containing list of all code source files <em>(build/src/epics/util/sources.model_name)</em> \n
#//	- File containing list of all DAQ channels and rates <em>(build/src/epics/fmseq/model_name_daq)</em>.
#//		- NOTE: Opened here, but actually written to by <em>lib/Parser3.pm</em>
#//	- Foton IIR filter definition file <em>(build/build/model_nameepics/config/MODEL_NAME.txt)</em>
#//	- Various common MEDM screen files, including:
#//		- MODEL_NAME_GDS_TP.adl: Contains primary runtime diags, including timing, networks, DAQ. 
#//			- This code calls sub in <em>lib/medmGenGdsTp.pm</em> to actually produce the MEDM file.
#//		- MODEL_NAME_DAC_MONITOR_num.adl: Outputs from DAC modules, directly from the main sequencer code. 
#//			- This code calls sub in <em>lib/DAC.pm</em> or <em>lib/DAC18.pm</em> to actually produce the MEDM files.
#//		- MODEL_NAME_MONITOR_ADCnum.adl: Inputs to all ADC channels used by the model. 
#//			- This code calls sub in <em>lib/ADC.pm</em> to actually produce the MEDM files.
#//		- MODEL_NAME_MATRIXNAME.adl: Inputs from matrix elements.
#//			- This code calls sub in <em>mkmatrix.pl</em> to actually produce the MEDM files.
#//		- MODEL_NAME_FILTERNAME.adl: Interface for Filter modules.
#//			- This code calls sub in <em>/lib/Filt.pm</em> to actually produce the MEDM files.
#//	- Parser diagnostics file <em>(build/epics/util/diags.txt)</em>, which lists all parts and their connections after model parsing.

#	
#//	
#// <b>BASIC CODE SEQUENCE:</b>: \n
#//	

die "Usage: $PROGRAM_NAME <MDL file> <Output file name> [<DCUID number>] [<ifo>] [<speed>]\n\t" . "ifo is (e.g.) H1, M1; speed is 2K, 16K, 32K or 64K\n"
        if (@ARGV != 2 && @ARGV != 3 && @ARGV != 4 && @ARGV != 5);

#Setup current working directory and pointer to RCG source directory.
$currWorkDir = &Cwd::cwd();
$rcg_src_dir = $ENV{"RCG_SRC_DIR"};
$rcg_build_dir = $ENV{"RCG_BUILDD"};
die "RCG_BUILDD env var not specified, exiting." unless $rcg_build_dir;
$mbufsymfile = $ENV{"MBUF_SYM"};
$gpssymfile = $ENV{"GPSTIME_SYM"};
$cpuisolatorfile = $ENV{"RTS_CPU_ISOLATOR_SYM"};
$rtsloggerfile = $ENV{"RTS_LOGGER_SYM"};
$dolphinsymfile = $ENV{"DOLPHIN_SYM"};
$dolphinGen = 2;

if (! length $rcg_src_dir) { $rcg_src_dir = "$currWorkDir/../../.."; }

@sources = ();

#//	- Search for the Matlab file in the RCG_LIB_PATH; exit if not found \n
@rcg_lib_path = split(':', $ENV{"RCG_LIB_PATH"});
push @rcg_lib_path, "$rcg_src_dir/src/epics/simLink";
#print join "\n", @rcg_lib_path, "\n";
my $model_file_found = 0;
$mdlfile = $ARGV[0];
foreach $i (@rcg_lib_path) {
	my $fname = $i;
	$fname .= "/";
	$fname .= $ARGV[0];
	if (-r $fname) {
		print "Model file found $fname", "\n";
		print "RCG_LIB_PATH=". join(":", @rcg_lib_path)."\n";
		$ARGV[0] = $fname;
		$model_file_found = 1;
		push @sources, $fname;
		last;
	}
}

# Exit if cannot find the Matlab file.
die "Could't find model file $ARGV[0] on RCG_LIB_PATH " . join(":", @rcg_lib_path). "\n"  unless $model_file_found;

# Default is to run LIGO patched Linux; Windriver support removed 1/14/2013 RGB.
print "Generating Firm Real-time code for patched vanilla Linux kernel\n";

# Get MAX_DIO_MODULES allowed from header file.
# This is used by Parser3.pm to stop compile if RCG limits exceeded.
my $mdmStr = `grep "define MAX_DIO_MODULES" $rcg_src_dir/src/include/drv/cdsHardware.h`;
my @mdmNum = ($mdmStr =~ m/(\d+)/);
$maxDioMod = pop(@mdmNum);

# site/ifo/target config

$site = uc $ENV{"SITE"};
die "SITE env var not specified." unless $site;
$ifo = uc $ENV{"IFO"};
die "IFO env var not specified." unless $ifo;
$lsite = lc $site;
$lifo = lc $ifo;

$target = $ENV{"RCG_TARGET"};
if($target eq "") {
$target = "/opt/rtcds/" . $lsite . "/" . $lifo;
}

# Allow the cdsParameters to be set at build time
$cdsParametersOverride = $ENV{"RCG_OVERRIDE_CDS_PARAMETERS"};
if ($cdsParametersOverride ne "") {
    $cdsParametersOverride =~ s/:/\\n/g; #Transform : sep list to \n sep list
    print STDERR "Warning: cdsParameter override with environment RCG_OVERRIDE_CDS_PARAMETERS='$cdsParametersOverride'\n";
}

# Initialize default settings.
$sitedepwarning = 0;
$adcmasterdepwarning = 0;
$timemasterdepwarning = 0;
$perCycle_us = 0; # In microseconds (default setting)
$brate = "52";
$dcuId = 0; # Default dcu Id
$targetHost = "dummy"; # Default target host name
$edcusync = "none";
$iopModel = -1;
$dacWdOverride = -1;
$dolphin_time_xmit = -1;
$dolphinTiming = -1;
$diagTest = -1;
$biotest = 0;
$flipSignals = 0;
$ipcrateHz = 0;
$ipccycle = 0;
$virtualiop = 0;
$force_shm_ipc = 0;
$no_cpu_shutdown = 0;
$edcu = 0;
$casdf = 0;
$globalsdf = 0;
$pciNet = -1;
$no_sync = 0; # Sync up to 1PPS by default
$test1pps = 0; # Forrce Sync up to 1PPS for testing
$no_daq = 0; # Enable DAQ by default
$gdsNodeId = 0;
$ifoid = 0; # Default ifoid for the DAQ
$nodeid = 0; # Default GDS node id for awgtpman
$no_oversampling = 0; # Default is to iversample
$no_dac_interpolation = 0; # Default is to interpolate D/A outputs
$max_name_len = 39;	# Maximum part name length
$dacKillMod[0][0] = undef;
$dacKillModCnt[0] = undef;
@dacKillDko = ('x') x $Dac_common::max_dac_modules;
$dkTimesCalled = 0;
$remoteGpsPart = 0;
$remoteGPS = 0;
$requireIOcnt = 1;
$vectorization = "none";
$noiseGeneratorSeed = "none";
$gaussNoiseGeneratorSeed = "none";

# duotone variable frequency values

$average_duotone_frequency_hz = 960.5;
$duotone_samples = 11;
$duotone_lptc_setting = "LPTC_DT_FREQ_960";

#Following provide for non standard IOP clock rates
$adcclockHz = 65536;
$modelrateHz = 65536;
$clock_div = 1;
$daq_prefix="DC0";
$allBiquad = 1;
$internalclk = 0;
$userspacegps = 0;
$rfmDelay = -1;
$time0_delay_us = 0;
$extra_includes = "";
$extra_cflags = "";
$extra_usp_linkoptions = "";
$statespace_num_parts = 0;


# these epics vars are needed but not created by a part
@other_epics_vars = ();

# eventually contains all epics vars structs in order, with other_epics_vars at the end
@all_epics_vars = ();

# Load model name without .mdl extension.
$skeleton = $ARGV[1];

# First two chars of model name must be IFO, such as h1, l1, h2, etc.
$ifo_from_mdl_name = substr($skeleton, 0, 2);

#//	- Create the paths for RCG output files. \n
print "file out is $skeleton\n";

$modelCodeFilepath = $rcg_build_dir . "/models/";
$modelCodeFilepath .= $skeleton;

$modelCodeKernDir = $modelCodeFilepath . "/kernel_mod/";
$modelCodeUspDir = $modelCodeFilepath . "/userspace/";
$modelEpicsCodeDir = $modelCodeFilepath . "/epics/";
$modelConfigCodeDir = $modelCodeFilepath . "/config/";
$statespaceConfigFile = $modelConfigCodeDir . "statespace.json";
$newFilterConfigFile = $modelConfigCodeDir . "filters.json";

#This generates /path/to/module(_usp)/modelname_core.c
$modelCodeKernFilepath = $modelCodeKernDir. $skeleton . "_core.c"; 
$modelCodeUspFilepath = $modelCodeUspDir . $skeleton . "_core.c";

$modelHeaderFilepath = $modelCodeFilepath. "/include/";
$modelHeaderFilepath .= $skeleton;
$modelHeaderFilepath .= ".h";

$meFile = $modelEpicsCodeDir;
$meFile .= "Makefile\.";
$meFile .= $ARGV[1];
$meFile .= epics;

$epicsScreensDir = $modelEpicsCodeDir ."src/medm";
$caqtdmTempDir   = $modelEpicsCodeDir ."src/caqtdm_tmp/";
$caqtdmScreensDir = $modelEpicsCodeDir . "src/medm";
$configFilesDir = $modelEpicsCodeDir . "src/config";
$compileMessageDir = $modelCodeFilepath . "/logs/";

$warnMsgFile = $compileMessageDir . $skeleton . "_warnings.log";
$connectErrFile = $compileMessageDir . $skeleton . "_partConnectErrors.log";
$partConnectFile = $compileMessageDir . $skeleton . "_partConnectionList.txt";
$partConnectFileFilteredADC = $configFilesDir . "/partConnectionListFilteredADC.txt";
$partSequenceFile = $compileMessageDir . $skeleton . "_partSequence.txt";

# This is where the various RCG output files are created and opened.
if (@ARGV == 2) { $skeleton = $ARGV[1]; }
# Open files for EPICS generation by fmseq.pl
# Need to open early as Parser3.pm will write filter name info first.
open(EPICS,">$modelEpicsCodeDir/fmseq/".$ARGV[1]) || die "cannot open output file for writing";
open(DAQ,">$modelEpicsCodeDir/fmseq/".$ARGV[1]."_daq") || die "cannot open DAQ output file for writing";
# Open compilation message files
open(WARNINGS,">$warnMsgFile") || die "cannot open compile warnings output file for writing";
open(CONN_ERRORS,">$connectErrFile") || die "cannot open compile warnings output file for writing";
make_path( $modelCodeKernDir, { mode => 0755 });
make_path( $modelCodeUspDir, { mode => 0755 });
make_path( $modelEpicsCodeDir, { mode => 0755 });
make_path( $modelConfigCodeDir, { mode => 0755 });
open(OUT,">".$modelCodeKernFilepath) || die "cannot open c file for writing $modelCodeKernFilepath";
open(OUT2,">".$modelCodeUspFilepath) || die "cannot open c file for writing $modelCodeUspFilepath";
# Save existing front-end Makefile
@months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
my $year = 1900 + $yearOffset;
$theTime = sprintf("%d_%s_%02d_%02d:%02d:%02d", $year, $months[$month], $dayOfMonth, $hour, $minute, $second);
my $hfname = "$rcg_src_dir/src/include/$ARGV[1].h";
if (-e $hfname) {
	system("/bin/mv -f $hfname $hfname~");
}
# Need to open header file early, as calls in Parser3.pm will start the writing process.
open(OUTH,">".$modelHeaderFilepath) || die "cannot open header file for writing:".$modelHeaderFilepath;


$mySeq = 0;
$connects = 0;
$ob = 0;
$subSys = 0;
$inBranch = 0;
$endBranch = 0;
$adcCnt = 0;
$dacCnt = 0;
$dacKillCnt = 0;
$boCnt = 0;
$filtCnt = 0;
$firCnt = 0;
$useWd = 0;
$gainCnt = 0;
$busPort = -1;
$trigCnt = 0;                                                              # ===  MA  ===
$trigOut = 0;                                                              # ===  MA  ===
$convDeg2Rad = 0;                                                          # ===  MA  ===
$groundDecl = 0;                                                           # =+=  MA  =+=
$groundInit = 0;                                                           # =+=  MA  =+=
$dac16Cnt = 0;
$dac18Cnt = 0;

# IPCx PART CODE VARIABLES
$ipcxCnt = 0;                                                              # ===  IPCx  ===
$ipcxDeclDone = 0;                                                         # ===  IPCx  ===
$ipcxInitDone = 0;                                                         # ===  IPCx  ===
$ipcxBlockTags[0] = undef;
$ipcxParts[0][0] = undef;
$ipcxTagCount = 0;
$ipcxReset = "";
# END IPCx PART CODE VARIABLES

$oscUsed = 0; # Needed by OSC part for one time inits.
$useFIRs = 0;
# ***  DEBUG  ***
# $useFIRs = 1;
# ***  DEBUG  ***

# set debug level (0 - no debug messages)
$dbg_level = 2;


my $system_name = $ARGV[1];
my $header_guard_string = "\U$system_name"."_H_INCLUDED";
print OUTH "\#ifndef ".$header_guard_string."\n";
print OUTH "\#define ".$header_guard_string."\n";
print OUTH "\#define SYSTEM_NAME_STRING_LOWER \"\L$system_name\"\n";

require "lib/ParsingDiagnostics.pm";

#Initialize various parser variables.
init_vars();

#//	- Read .mdl file and flatten all subsystems to top level subsystem part. \n
#//		- Done by making calls to subs in <em>lib/Parers3.pm</em>
require "lib/Parser3.pm";
open(IN,"<".$ARGV[0]) || die "cannot open mdl file $ARGV[0]\n";
die unless CDS::Parser::parse();
die unless CDS::Parser::process();

close(IN);

#Print warning messages if model contains Parameter block entries due for deprecation
if(($iopModel == 1) and ($modelrateHz > $adcclockHz) and ($clock_div == 1)) 
{
	die "Error:\nModel rate $modelrateHz > ADC clock $adcclockHz\nFix adcclock in Param Block\n*****\n";
}
# The daqd does not recognize all dcuids.  This is for historical reasons that should be fixed.
# In the mean time don't generate a model that the daq will not recognize data from.
# Values taken from daqmap.h.  Note: this ignores the cit_40m setting, which just shouldn't be
# used. JKH
if(($dcuId < 5) or (($dcuId > 12) and ($dcuId < 17)) or (($dcuId > 256) and ($casdf==0)))
{
    die "Error:\nModel dcuid must be in the range of [5-12] or [17-255] (unless it is a casdf model).\nFix dcuid in Param Block\n*****\n";
}
if($sitedepwarning == 1) {
	print WARNINGS "WARNING: The 'site=' designator in the model parameter block\n\t is scheduled for deprecation in future releases. \n";
	print WARNINGS "*******: Please replace site=$ifo designator with ifo=$ifo \n";
}
if($adcmasterdepwarning == 1) {
	print WARNINGS "WARNING: The 'adcMaster=' designator in the model parameter block\n\t is scheduled for deprecation in future releases. \n";
	print WARNINGS "*******: Please replace adcMaster=1 designator with iop_model=1 \n";
}
if($timemasterdepwarning == 1) {
	print WARNINGS "WARNING: The 'time_master=' designator in the model parameter block\n\t is scheduled for deprecation in future releases. \n";
	print WARNINGS "*******: Please replace time_master=1 designator with dolphin_time_xmit=1 \n";
}

#//	
#// Model now consists of top level parts and single level subsystem(s). <em>Parser3.pm</em> has taken care of all part
#// removals/connections for lower level subsystems.\n
#// Following parsing code now needs to finish top level connections. \n

$systemName = substr($systemName, 2, 3);
$plantName = $systemName; # Default plant name is the model name



#//	- Perform some specific part checks/processing.
#//		- Check parts which require GROUND input in fact have ground connections. \n
# 
# Make sure all EpicsCounter, EpicsMbbi, and
# EpicsStringIn modules have Ground as input
#
for ($ii = 0; $ii < $partCnt; $ii++) {
   if ( ($partType[$ii] eq "EpicsCounter") ||
#       ($partType[$ii] eq "EpicsMbbi") ||
        ($partType[$ii] eq "EpicsStringIn") ) {
      if ( ($partInCnt[$ii] != 1) || ($partInput[$ii][0] !~ /Ground/) ) {
         die "\n***ERROR: $partType[$ii] with name $xpartName[$ii] must have Ground as input\n";
      }
   }
}

#//		- Process all IPC parts in one go. Requires <em>lib/IPCx.pm</em>, with call to procIpc. \n
require "lib/IPCx.pm";
("CDS::IPCx::procIpc") -> ($partCnt);
if(defined $ENV{'SIMULATION_BUILD'})
{
	# When in simulation build receivers are added to the IPC file
	# But we need to reprocess so we can load their info
	$ipcxCnt = 0;                                                              # ===  IPCx  ===
	$ipcxDeclDone = 0;                                                         # ===  IPCx  ===
	$ipcxInitDone = 0;                                                         # ===  IPCx  ===
	$ipcxBlockTags[0] = undef;
	$ipcxParts[0][0] = undef;
	$ipcxTagCount = 0;
	$ipcxReset = "";
	("CDS::IPCx::procIpc") -> ($partCnt);
}


#//		- Check that all subsystem INPUT parts are connected; else exit w/error. \n
$kk = 0;
require "lib/Input.pm";
$kk = ("CDS::Input::checkInputConnect") -> ($partCnt,0);
if($kk > 0)
{
         die "\n***ERROR: Found total of ** $kk ** INPUT_X parts not connected\n\n";
}



#//	
#//	- Need to process BUSS, FROM and GOTO parts so they can be removed later.

#//		- Find all parts which have input from Bus Selector parts and feed thru actual part connections.\n
#//			- Change part input connect from BUSS to part feeding signal to BUSS.
#//			- Change output of part feeding BUSS directly to part receiving signal.
require "lib/BusSelect.pm";
("CDS::BusSelect::linkBusSelects") -> ($partCnt);

####################
#print "Looped thru $partCnt looking for BUSS \n\n\n";

#//		-  FIND and replace all GOTO links
# Supports MATLAB tags ie types Goto and From parts.
#//			- This section searches all part inputs for From tags, finds the real name
#// of the signal being sent to this tag, and substitutes that name at the part input. \n

require "lib/Tags.pm";
("CDS::Tags::replaceGoto") -> ($partCnt);

################


#//		- FIND and replace all FROM links \n
# Supports MATLAB tags ie types Goto and From parts.
# This section searches all part inputs for From tags, finds the real name
# of the signal being sent to this tag, and substitutes that name at the part input.

("CDS::Tags::replaceFrom") -> ($partCnt);

##################


#//	- Continue to make part connections.
# ********************************************************************
#//		- Take all of the part outputs and find connections.
#// Fill in connected part numbers and types.\n
for($ii=0;$ii<$partCnt;$ii++)
{
	for($jj=0;$jj<$partOutCnt[$ii];$jj++)
	{
	   for($kk=0;$kk<$partCnt;$kk++)
	   {
		if($partOutput[$ii][$jj] eq $xpartName[$kk])
		{
			$partOutNum[$ii][$jj] = $kk;
			$partOutputType[$ii][$jj] = $partType[$kk];
		}
	   }
	}
}

#//		-  Take all of the part inputs and find connections.
#// Fill in connected part numbers and types. \n
for($ii=0;$ii<$partCnt;$ii++)
{
	for($jj=0;$jj<$partInCnt[$ii];$jj++)
	{
	   for($kk=0;$kk<$partCnt;$kk++)
	   {
		if($partInput[$ii][$jj] eq $xpartName[$kk])
		{
			#print "Part Input Number $xpartName[$ii] $jj eq $kk\n";
			$partInNum[$ii][$jj] = $kk;
			$partInputType[$ii][$jj] = $partType[$kk];
			$partSysFromx[$ii][$jj] = -1;
		}
	   }
	}
}

#//	- Start the process of removing subsystems OUTPUT parts \n
for($ii=0;$ii<$partCnt;$ii++)
{
$foundCon = 0;
$foundSysCon = 0;
	if($partType[$ii] eq "OUTPUT")
	{
	for($jj=0;$jj<$partOutCnt[$ii];$jj++)
	{
	   for($kk=0;$kk<$partCnt;$kk++)
	   {
		# If OUTPUT connects to INPUT of another subsystem
		if($partType[$kk] eq "INPUT")
		{
	      for($ll=0;$ll<$partOutCnt[$kk];$ll++)
        	{
		if(($partOutput[$ii][$jj] eq $partInput[$kk][0]) && ($partOutputPort[$ii][$jj] == $partInputPort[$kk][0]))
		{
			#$partOutput[$ii][$jj] = $xpartName[$kk];
			#$partOutNum[$ii][$jj] = $kk;
			$partSysFrom[$kk] = $partSubNum[$ii];
                       $fromNum = $partInNum[$ii][0];
                       $fromPort = $partInputPort[$ii][0];
                       $toNum = $partOutNum[$kk][$ll];
                       $toPort = $partOutputPort[$kk][$ll];
			#print "Connection from $xpartName[$ii] $jj $fromNum $fromPort to $xpartName[$kk] $toNum $toPort\n";
			#print"\t$xpartName[$fromNum] $fromPort to $xpartName[$toNum] $toPort\n";
			for($vv=0;$vv<$partOutCnt[$fromNum];$vv++)
			{
				if($partOutput[$fromNum][$vv] eq $xpartName[$ii])
				{
					$fromLink = $vv;
				}
			}
                       $partOutput[$fromNum][$fromLink] = $xpartName[$toNum];
                       $partOutputType[$fromNum][$fromLink] = $partType[$toNum];
                       $partOutNum[$fromNum][$fromLink] = $toNum;
                       $partOutputPort[$fromNum][$fromLink] = $toPort;
                       $partInput[$toNum][$toPort] = $xpartName[$fromNum];
                       $partInputType[$toNum][$toPort] = $partType[$fromNum];
                       $partInNum[$toNum][$toPort] = $fromNum;
                       $partInputPort[$toNum][$toPort] = $fromPort;
                       $partSysFrom[$kk] = $partSubNum[$ii];
                       $partInputType[$kk][0] = "SUBSYS";
                       $partInNum[$kk][0] = $partSubNum[$ii];

			$foundSysCon = 1;
		}
		}
		}
	   }
	}

	# OUTPUT did not connect to INPUT, so find the part connections.
	if($foundCon == 0){
	for($jj=0;$jj<$partOutCnt[$ii];$jj++)
	{
	   for($kk=0;$kk<$nonSubCnt;$kk++)
	   {
	      $xx = $nonSubPart[$kk];
			if($partOutput[$ii][$jj] eq $partName[$xx])
			{
				$fromNum = $partInNum[$ii][0]; # OUTPUT part has only one input!
#  If OUTPUT part has only one input, then the line below can NOT be correct!
#				$fromPort = $partInputPort[$ii][$jj];
#  Replace with the following line:

				# Do not try to find the output by name
				if (0) {
				$fromPort = $partInputPort[$ii][0];
				for($xxx=0;$xxx<$partOutCnt[$fromNum];$xxx++)
				{
					if($xpartName[$ii] eq $partOutput[$fromNum][$xxx])
					{
						$fromPort = $xxx;
					}
				}
				} # 0

				# Add to the output count, do not try to find and replace
				$fromPort = $partOutCnt[$fromNum];
				$partOutCnt[$fromNum]++;

			# print " OUTPUT TO $xpartName[$ii] $xpartName[$xx] $partType[$xx]\n";
			# print "Maybe $xpartName[$xx] port $partOutputPort[$ii][$jj] $xpartName[$fromNum] $partType[$fromNum] port $fromPort\n";
				# Make output connection at source part
				$partOutput[$fromNum][$fromPort] = $xpartName[$xx];
				$partOutputType[$fromNum][$fromPort] = $partType[$xx];
				$partOutNum[$fromNum][$fromPort] = $xx;
				$partOutputPort[$fromNum][$fromPort] = $partOutputPort[$ii][$jj];
#print "$xpartName[$xx] $partType[$xx] $xx $partOutputPort[$ii][$jj]\n";
#print "$xpartName[$fromNum] $fromPort\n\n";
                       		# $partSysFromx[$xx][$fromCnt[$xx]] = $partSubNum[$ii];
				# Make input connection at destination part
#  If OUTPUT part has only one input, then the line below can NOT be correct!
#				$fromPort = $partInputPort[$ii][$jj];
#  Replace with the following line:
 				$fromPort = $partInputPort[$ii][0];
				$qq = $partOutputPort[$ii][$jj] - 1;
				$partInput[$xx][$qq] = $xpartName[$fromNum];
				$partInputType[$xx][$qq] = $partType[$fromNum];
				$partInNum[$xx][$qq] = $fromNum;
				$partInputPort[$xx][$qq] = $fromPort;
                       		$partSysFromx[$xx][$qq] = $partSubNum[$ii];
				$fromCnt[$xx] ++;
				$foundCon = 1;
			}
	   }
	}

	}

	# Did not find any connections to subsystem OUTPUT, so print error.
	if($foundCon == 0 && $foundSysCon == 0){
		print WARNINGS "WARNING  *********** No connection to subsystem output named  $xpartName[$ii] $partOutput[$ii][0] $partOutputPort[$ii][0]\n";
	}
	}
}

#//	- Find connections for non subsystem (top level) parts \n
for($ii=0;$ii<$partCnt;$ii++)
{
	$xx = $ii;
	# If part is BUSS, indicating an ADC input part
	if($partType[$xx] eq "BUSS")
	{
		for($jj=0;$jj<$partOutCnt[$xx];$jj++)
		{
		   $mm = $partOutputPort[$xx][$jj]+1;
		   for($kk=0;$kk<$partCnt;$kk++)
		   {
			# Handle ADC input connections to a subsystem, as indicated by
			# an INPUT part.
			if($partType[$kk] eq "INPUT")
			{
				if(($partOutput[$xx][$jj] eq $partInput[$kk][0]) && ($mm == $partInputPort[$kk][0]))
				{
				$fromNum = $xx;
				$fromPort = $partOutputPortUsed[$xx][$jj];
				# $fromPort = $partInputPort[$kk][0];
				$adcName = $partInput[$xx][$fromPort];
				$adcTest = substr($adcName,0,3);
				if($adcTest eq "adc")
                                {
				$partInput[$kk][0] = $xpartName[$xx];
				$partInputType[$kk][0] = "Adc";
				$partInNum[$kk][0] = $xx;
				#$partInputPort[$kk][0] = $fromPort;
				$partSysFrom[$kk] = 100 + $xx;
				#print "Found ADC INPUT connect from $xpartName[$xx] to $xpartName[$kk] $partOutputPort[$xx][$jj] $jj  input $fromPort $partInput[$xx][$fromPort]\n";
				for($ll=0;$ll<$partOutCnt[$kk];$ll++)
				{
					$adcName = $partInput[$xx][$fromPort];
				$adcTest = substr($adcName,0,8);
				#print "FOUND INPUT BUSS connection  $xpartName[$kk] $adcTest!!!!!!!!!!!!!!!!!\n";
					$adcNum = substr($adcName,4,1);
					$adcChan = substr($adcName,6,2);
					$toNum = $partOutNum[$kk][$ll];
				        $toPort = $partOutputPort[$kk][$ll];
					$partInNum[$toNum][$toPort] = $adcNum;
					#$partInput[$toNum][$toPort] = $xpartName[$xx];
					$partInput[$toNum][$toPort] = $adcName;
					$partInputPort[$toNum][$toPort] = $adcChan;
					$partInputType[$toNum][$toPort] = "Adc";
					#print "\tNew adc connect $xpartName[$toNum] $adcNum $adcChan to partnum $partInput[$toNum][$toPort]\n";
				}
				} else {
    					($var1,$var2) = split(' ',$adcName);
				        for($yy=0;$yy<$partCnt;$yy++)
				        {
						if($xpartName[$yy] eq $var1)
						{
							$conPartType = $partType[$yy];
							$conPortNum = $var1;
							$conInNum = $yy;
							#$partInputType[$kk][0] = "PART";
							#$partInputPort[$kk][0] = $var2;
							#$$partInNum[$kk][0] = $yy;
							#$partInNum[$kk][0] = $partOutNum[$xx][$jj];;
							#print "\t SUBSYS input with bus name $xpartName[$yy] $conPartType $conPortNum $conInNum\n";
						}
					}
					for($ll=0;$ll<$partOutCnt[$kk];$ll++)
					{
					#print "FOUND INPUT BUSS connection  $xpartName[$kk] $adcTest!!!!!!!!!!!!!!!!!\n";
						$toNum = $partOutNum[$kk][$ll];
						$toPort = $partOutputPort[$kk][$ll];
						$partInNum[$toNum][$toPort] = $conInNum;
						#$partInput[$toNum][$toPort] = $xpartName[$xx];
						$partInput[$toNum][$toPort] = $var1;
						$partInputPort[$toNum][$toPort] = $var2;
						$partInputType[$toNum][$toPort] = $conPartType;
						#print "\tNew BUSS connect $xpartName[$toNum]  to partnum $partInput[$toNum][$toPort]\n";
						$partOutput[$conInNum][$var2] = $xpartName[$toNum];
						$partOutNum[$conInNum][$var2] = $toNum;
						$partOutputType[$conInNum][$var2] = $partType[$toNum];
					}
				}
				}
			}
			# Handle ADC input connections directly to a part not in a subsystem.
			if($partType[$kk] ne "INPUT")
			{
				if(($partOutput[$xx][$jj] eq $xpartName[$kk]))
				{
				 # print "Found ADC NP connect $xpartName[$xx] to $xpartName[$kk] $partOutputPort[$xx][$jj]\n";
				 # print "$jj $partOutputPort[$xx][$jj] $partOutputPortUsed[$xx][$jj]\n";
				$fromNum = $xx;
				#$fromPort = $jj;
				#$fromPort = $partInputPort[$kk][0];
				#$fromPort = $partOutputPort[$xx][$jj];

				#print "FOUND BUSS connection  $xpartName[$kk] $adcTest!!!!!!!!!!!!!!!!!\n";

				$fromPort = $partOutputPortUsed[$xx][$jj];
				$toPort = $partOutputPort[$xx][$jj];
				$adcName = $partInput[$xx][$fromPort];
				$adcTest = substr($adcName,0,3);
				if($adcTest eq "adc")
				{
				#print "\tFOUND ADC  connection  from $xpartName[$xx] to $xpartName[$kk] $adcName $adcTest!!!!!!!!!!!!!!!!!\n";
				$partInput[$kk][$toPort] = $xpartName[$xx];
				$partInputType[$kk][$toPort] = "Adc";
				$partInNum[$kk][$toPort] = $xx;
				$partInputPort[$kk][$toPort] = $fromPort;
					$adcNum = substr($adcName,4,1);
					$adcChan = substr($adcName,6,2);
					$partInput[$kk][$toPort] = $adcName;
					$partInputPort[$kk][$toPort] = $adcChan;
					$partInNum[$kk][$toPort] = $adcNum;
				} else {
					#print "FOUND BUSS connection which is not ADC $xpartName[$kk] $adcTest!!!!!!!!!!!!!!!!!\n";
				}
				}
			}
		   }
		}
	}
}

	# Handle part connections, where neither part is an ADC part.
	#if(($partType[$xx] ne "BUSS") && ($partType[$xx] ne "FROM") && ($partType[$xx] ne "GOTO") )
for($ii=0;$ii<$nonSubCnt;$ii++)
{
	$xx = $nonSubPart[$ii];
	if($partType[$xx] ne "BUSS")
	{
		for($jj=0;$jj<$partOutCnt[$xx];$jj++)
		{
		   $mm = $partOutputPort[$xx][$jj]+1;
		   for($kk=0;$kk<$partCnt;$kk++)
		   {
			if($partType[$kk] eq "INPUT")
			{
				if(($partOutput[$xx][$jj] eq $partInput[$kk][0]) && ($mm == $partInputPort[$kk][0]))
				{
			         $partInputType[$kk][0] = "PART";
				$partInNum[$kk][0] = $xx;
				
				# print "OUTPUT COUNT for $xpartName[$xx] is $partOutCnt[$kk]  ** $mm ** \n";
				for($ll=0;$ll<$partOutCnt[$kk];$ll++)
				{
					$toNum = $partOutNum[$kk][$ll];
					$toPort = $partOutputPort[$kk][$ll];
					$toPort1 = $partOutputPortUsed[$kk][0];
					#$toPort1 = $partOutputPortUsed[$kk][$ll];
					$partInNum[$toNum][$toPort] = $xx;
					$partInput[$toNum][$toPort] = $xpartName[$xx];
					$partInputPort[$toNum][$toPort] = $toPort1;
					$partInputType[$toNum][$toPort] = $partType[$xx];

					$partOutput[$xx][$jj] = $xpartName[$toNum];
					$partOutputPort[$xx][$jj] = $toPort;
					$partOutNum[$xx][$jj] = $toNum;
					$partOutputType[$xx][$jj] = $partType[$toNum];
					# print "Connected $xpartName[$xx] to $xpartName[$toNum] by bypassing INPUT $xpartName[$kk]\n"
				}
				$partSysFrom[$kk] = 100 + $xx;
				}
			}
		   }
		}
	}
}

#// -  Remove all parts which will not require further processing in the code for the part
#// total, also do a part check for blocks with different capitalization that are going to
#// emit c code that will be lowercased (causing collisions)
$ftotal = $partCnt;

my %seen; #Hash that keeps track of the names we have seen before
my %noCode = map {$_ => 1}  qw(INPUT OUTPUT BUSC BUSS FROM GOTO); #Hash of non-generating parts
my @duplicates = ();

for($kk=0;$kk<$partCnt;$kk++)
{
    if(($partType[$kk] eq "INPUT") || ($partType[$kk] eq "OUTPUT") || ($partType[$kk] eq "BUSC")
        || ($partType[$kk] eq "BUSS") || ($partType[$kk] eq "EpicsIn") || ($partType[$kk] eq "TERM")
        || ($partType[$kk] eq "FROM") || ($partType[$kk] eq "GOTO") || ($partType[$kk] eq "GROUND")
        || ($partType[$kk] eq "CONSTANT") || ($partType[$kk] eq "Adc") || ($partType[$kk] eq "Gps")
        || ($partType[$kk] eq "StateWord") || ($partType[$kk] eq "ModelRate") || ($partType[$kk] eq "EXC"))
    {
        $ftotal --;
    }

    # Check to see if we have a part with the same lower case name,
    # and neither parts are of a no code generating type
    if ( exists $seen{ lc $xpartName[$kk] }
         and not exists $noCode{$partType[$kk]}
         and not exists $noCode{ $seen{ lc $xpartName[$kk] }[1]  } )
    {
        push(@duplicates, "\tFirst (part, type) is: ($xpartName[$kk], $partType[$kk]),".
                          " other part is ($seen{ lc $xpartName[$kk]}[0], $seen{ lc $xpartName[$kk]}[1])\n");
    }
    else
    {
        my @val = ($xpartName[$kk], $partType[$kk]);
        $seen{ lc $xpartName[$kk] } = \@val;
    }
}

if ( scalar(@duplicates) > 0) #If we found 1 or more issues
{
    my $whole_error = "ERROR - Some part(s) failed the duplicate name check. " .
                      "Two parts, that generate code, with the same name (but different capitalization) were found.\n" .
                      "This can cause an issue with code generation, please rename one of the parts, from each pair.\n";
    $whole_error = $whole_error . join('', @duplicates);
    die $whole_error . "\n";
}

print "Total parts to process $ftotal\n";

# DIAGNOSTIC
print "Found $subSys subsystems\n";

#//	
#// \n
#// At this point, all parts should have all of their defined inputs and output connections made.
#//	- Write a parts and connection list to file <em>(build/modelname_partConnectionList.txt)</em> for diagnostics. \n\n

# Diags file will provide list of all parts and their connections. 
require "lib/createDiagsFile.pm";
#A python script called by writeDiagFile 
#uses the configFilesDir as output so we create it here
mkpath $configFilesDir, 0, 0755; #A python script called by writeDiagFile 
$kk = ("CDS::createDiagsFile::writeDiagFile") -> ($partConnectFile, $partConnectFileFilteredADC);


#//	- Verify that all parts now have input connections. If not,
#//		- Write missing connections list to <em>(build/modelname_partConnectionErrors.log)</em>
#//		- Exit on error
$kk = 0;
# Check all INPUT parts to verify they are all connected.
require "lib/Input.pm";
$kk = ("CDS::Input::checkInputConnect") -> ($partCnt,1);

if($kk > 0)
{
        close CONN_ERRORS;
        die "\n***ERROR: Found total of ** $kk ** INPUT_Y parts not connected\n\n";
}

# Check all of the parts to verify they have all their required inputs connected.
for($ii=0;$ii<$partCnt;$ii++)
{
        # INPUT partType is excluded here, either because lib/INPUT.pm does not exist
        # (on case-sensitive FS), or by explicit test (on case-insensitive FS)
        if ( -e "lib/$partType[$ii].pm" && $partType[$ii] ne "INPUT" ) {
           $mask = ("CDS::" . $partType[$ii] . "::checkInputConnect") -> ($ii);
           if ($mask eq "ERROR") { $kk ++; }
        }
}
close CONN_ERRORS;
if($kk > 0)
{
	print "***\n***ERROR: Found total of ** $kk ** parts with one or more inputs not connected.\n";
	my $emsg = "cat ";
	$emsg .= $compileMessageDir;
	$emsg .= $skeleton;
	$emsg .= "_partConnectErrors.log";
	system($emsg);
         die "\nSee $skeleton\_partConnectErrors.log file for details.\nA complete list of model part connections can be found in $skeleton\_partConnectionList.txt\n\n";
}

#//	
#// \n\n Start the process of producing the code sequencing. 
print "Found $adcCnt ADC modules part is $adcPartNum[0]\n";
die "***ERROR: At least one ADC part is required in the model\n" if ($adcCnt < 1);
print "Found $dacCnt DAC modules part is $dacPartNum[0]\n";
print "Found $boCnt Binary modules part is $boPartNum[0]\n";

($::maxAdcModules, $::maxDacModules) =
	CDS::Util::findDefine("src/include/drv/cdsHardware.h", #Rest of path added in function
			"MAX_ADC_MODULES", "MAX_DAC_MODULES");

die "***ERROR: Too many ADC modules (MAX = $::maxAdcModules): ADC defined = $adcCnt\n" if ($adcCnt > $::maxAdcModules);
die "***ERROR: Too many DAC modules (MAX = $::maxDacModules): DAC defined = $dacCnt\n" if  ($dacCnt > $::maxDacModules);

#//	- Need to remove some parts from processing list, such as BUSS, DELAY, GROUND, as code is not produced for these parts.
#//		- Loop thru all of the parts within a subsystem.
for($ii=0;$ii<$subSys;$ii++)
{
	$partsRemaining = $subSysPartStop[$ii] - $subSysPartStart[$ii];
	$counter = 0;
	$ssCnt = 0;
# 	print "sequencing $ii $subSysName[$ii]\n";
#  	print "SUB $ii has $partsRemaining parts *******************\n";
	for($jj=$subSysPartStart[$ii];$jj<$subSysPartStop[$ii];$jj++)
	{
		if(($partType[$jj] eq "INPUT") || ($partType[$jj] eq "BUSS") || ($partType[$jj] eq "GROUND") || ($partType[$jj] eq "EpicsIn") || ($partType[$jj] eq "CONSTANT") || ($partType[$jj] eq "EzCaRead") || ($partType[$jj] eq "DELAY") || ($partType[$jj] eq "Gps") || ($partType[$jj] eq "StateWord") || ($partType[$jj] eq "ModelRate") || ($partType[$jj] eq "EXC"))
		{
			if(($partType[$jj] ne "DELAY"))
			{
				$partsRemaining --;
				$partUsed[$jj] = 1;
			}
			for($kk=0;$kk<$partOutCnt[$jj];$kk++)
			{
				$ll = $partOutNum[$jj][$kk];
				# check that the part is really inside this subsystem
				if(($ll >= $subSysPartStart[$ii]) && ($ll < $subSysPartStop[$ii]))
				{
					$seqNum[0][$counter] = $ll;
					$counter ++;
				}
			}
		}
		if(($partType[$jj] eq "OUTPUT") || ($partType[$jj] eq "FROM") || ($partType[$jj] eq "GOTO") ||($partType[$jj] eq "TERM") || ($partType[$jj] eq "BUSC") || ($partType[$jj] eq "Adc"))
		{
			$partsRemaining --;
			$partUsed[$jj] = 1;
		}
	}
	print "Found $counter Inputs for subsystem $ii with $partsRemaining parts*********************************\n";
	$xx = 0;
	$ts = 1;
	#until(($partsRemaining < 1) || ($xx > 200))
	until($xx > 100)
	{
		$xx ++;
		$loop = $counter ++;
		$counter = 0;
		if($ts == 1) {
			$ts = 0;
			$ns = 1;
		}
		else {
			$ts = 1;
			$ns = 0;
		}
		for($jj=0;$jj<$loop;$jj++)
		{
			$mm = $seqNum[$ts][$jj];
			$partInUsed[$mm] ++;
			if(($partInUsed[$mm] >= $partInCnt[$mm]) && ($partUsed[$mm] == 0))
			{
				$partUsed[$mm] = 1;
				$partsRemaining --;
				$seq[$ii][$ssCnt] = $mm;
				$seqName[$ii][$ssCnt] = $xpartName[$mm];
				 #print "Sub $ii part $ssCnt = $mm $xpartName[$mm]\n";
				$ssCnt ++;
				# don't follow outputs if part is a DELAY.  These were followed in the first loop.
				if($partType[$mm] ne "DELAY") {
					for($kk=0;$kk<$partOutCnt[$mm];$kk++)
					{
						$ll = $partOutNum[$mm][$kk];
						if(($ll >= $subSysPartStart[$ii]) && ($ll < $subSysPartStop[$ii]))
						{
							$seqNum[$ns][$counter] = $ll;
							$counter ++;
						}
					}
				}
			}
		}

	}
	print " ********************* Parts remaining = $partsRemaining\n";
	$seqParts[$ii] = $ssCnt;
}
$partsRemaining = 0;
$searchCnt = 0;
#//		- Loop thru all of the parts at model top level.
for($ii=0;$ii<$nonSubCnt;$ii++)
{
			$xx = $nonSubPart[$ii];
	if(($partType[$xx] ne "BUSC") && ($partType[$xx] ne "FROM") &&($partType[$xx] ne "GOTO") && ($partType[$xx] ne "BUSS")
        && ($partType[$xx] ne "Adc") && ($partUsed[$xx] != 1))
	{
		$searchPart[$partsRemaining] = $xx;
		$searchCnt ++;
		$partsRemaining ++;
		#print "Part num $xx $partName[$xx] is remaining\n";
	}
}
$subRemaining = $subSys;
$seqCnt = 0;

#//	-  Construct parts linked list \n
#
foreach $i (0 .. $subSys-1) {
	debug(0, "Subsystem $i ", $subSysName[$i]);
}

# First pass defines processing step 0
# It finds all input sybsystems
#//		- First pass

#//			- Determine if subsystem has all of its inputs from ADC; if so, it can be added to process list.
for($ii=0;$ii<$subSys;$ii++)
{
$subUsed[$ii] = 0;
$allADC = 1;
	#print "system $ii: subCntr=$subCntr[$ii]\n";
	for($jj=0;$jj<$subCntr[$ii];$jj++)
	{
		#print "Checking $xpartName[$subInputs[$ii][$jj]] type $xpartName[$subInputs[$ii][$jj]]\n";
		if($subInputsType[$ii][$jj] ne "Adc")
		{
			$allADC = 0;
		}
	}
	if($allADC == 1) 
	{
		$subUsed[$ii] = 1;
		$seqList[$seqCnt] = $ii;
		$seqType[$seqCnt] = "SUBSYS";
		$seqCnt ++;
		#print "Subsys $ii $subSysName[$ii] has all ADC inputs and can go $seqCnt\n";
		$subRemaining --;
	}
}
#print "Searching parts $searchCnt\n";
#//			- Check if top level parts have ADC connections and therefore can go first.
for($ii=0;$ii<$searchCnt;$ii++)
{
	$allADC = 1;
	$xx = $searchPart[$ii];
	if($partUsed[$xx] == 0)
	{
		for($jj=0;$jj<$partInCnt[$xx];$jj++)
		{
			if($partInputType[$xx][$jj] ne "Adc")

			{
					$allADC = 0;
			}
		}
		if($allADC == 1) {
			#print "Part $xx $xpartName[$xx] can go next\n";
			$partUsed[$xx] = 1;
			$partsRemaining --;
			$seqList[$seqCnt] = $xx;
			$seqType[$seqCnt] = "PART";
			$seqCnt ++;
		}
	}
}
print "first pass done $partsRemaining $subRemaining\n";

#//		- Make 50 more passes through parts to complete linked list
# Second multiprocessing step
$numTries = 0;
until((($partsRemaining < 1) && ($subRemaining < 1)) || ($numTries > 60))
{
	$numTries ++;
	#//			- Continue through subsystem parts.
	for($ii=0;$ii<$subSys;$ii++)
	{
		$allADC = 1;
		if($subUsed[$ii] == 0)
		{
			for($jj=0;$jj<$subCntr[$ii];$jj++)
			{
				$yy = $subInputs[$ii][$jj];
				if(($yy<100) && ($subUsed[$yy] != 1))
				{
					$allADC = 0;
				}
				if($yy > 99)
				{
				$yy = $subInputs[$ii][$jj] - 100;
				for($kk=0;$kk<$searchCnt;$kk++)
				{
					if(($partUsed[$yy] != 1) && ($subInputsType[$ii][$jj] ne "Adc") && ($partType[$yy] ne "DELAY"))
					{
						$allADC = 0;
					}
				}
				}
			}
			if($allADC == 1) {
				# print "Subsys $ii $subSysName[$ii] can go next\n";
				$subUsed[$ii] = 1;
				$subRemaining --;
				$seqList[$seqCnt] = $ii;
				$seqType[$seqCnt] = "SUBSYS";
				$seqCnt ++;
			}
		}
	}
	#//			- Continue through top level parts.
	for($ii=0;$ii<$searchCnt;$ii++)
	{
		$allADC = 1;
		$xx = $searchPart[$ii];
		if($partUsed[$xx] == 0)
		{
			for($jj=0;$jj<$partInCnt[$xx];$jj++)
			{
				$yy = $partSysFromx[$xx][$jj];
				if($yy < 0)
				{
					
					$zz = $partInNum[$xx][$jj];
					if((!$partUsed[$zz]) && ($partInputType[$xx][$jj] ne "DELAY"))
					{
						$allADC = 0;
					}
				}
				else {
				if(($subUsed[$yy] != 1) && ($partInputType[$xx][$jj] ne "Adc") && ($partInputType[$xx][$jj] ne "DELAY"))
				{
						$allADC = 0;
				}
				}
			}
			if($allADC == 1) {
				#print "Part $xx $xpartName[$xx] can go next\n";
				$partUsed[$xx] = 1;
				$partsRemaining --;
				$seqList[$seqCnt] = $xx;
				$seqType[$seqCnt] = "PART";
				$seqCnt ++;
			}
		}
	}
}
#//		- If still have parts that are not in linked list, then print error and exit.
if(($partsRemaining > 0) || ($subRemaining > 0)) {
        print "Linkage failed (parts remaining $partsRemaining; subs remaining $subRemaining)\n";
# FIXME: the following code doen't report correctly failed parts
	for($ii=0;$ii<$subSys;$ii++)
	{
		if($subUsed[$ii] == 0)
		{
		print "Subsys $ii $subSysName[$ii] failed to connect\n";
		}
	}
	for($ii=0;$ii<$partCnt;$ii++)
	{
		if(($partUsed[$ii] == 0) && ($partType[$ii] ne "BUSC") && ($partType[$ii] ne "BUSS"))
		{
		print "Part $ii $xpartName[$ii] failed to connect\n";
		}
	}
	 exit(1);
}
$processCnt = 0;
$processSeqCnt = 0;
for($ii=0;$ii<$seqCnt;$ii++)
{
	#print "$ii $seqList[$ii] $seqType[$ii] $seqParts[$seqList[$ii]]\n";
	$processSeqStart[$processSeqCnt] = $processCnt;
	$processSeqCnt ++;
	if($seqType[$ii] eq "SUBSYS")
	{
		$xx = $seqList[$ii];
		# Save the name for subsystem for later use in code gennerator
		$processSeqSubsysName[$processCnt] = $subSysName[$xx];
		$processSeqType{$subSysName[$xx]} = $seqType[$ii];
		for($jj=0;$jj<$seqParts[$xx];$jj++)
		{
			$processName[$processCnt] = $seqName[$xx][$jj];
			$processPartNum[$processCnt] = $seq[$xx][$jj];
			# print "SUBSYS $processCnt $processName[$processCnt] $processPartNum[$processCnt]\n";
			$processCnt ++;
		}
	}
	if($seqType[$ii] eq "PART")
	{
		$xx = $seqList[$ii];
		$processName[$processCnt] = $xpartName[$xx];

if(($partType[$xx] eq "TERM") || ($partType[$xx] eq "GROUND") || ($partType[$xx] eq "FROM") || ($partType[$xx] eq "GOTO") || ($partType[$xx] eq "EpicsIn") || ($partType[$xx] eq "CONSTANT") || ($partType[$xx] eq "Gps") || ($partType[$xx] eq "StateWord") || ($partType[$xx] eq "ModelRate") || ($partType[$xx] eq "EXC")) 
{$ftotal ++;}
		$processSeqType{$xpartName[$xx]} = $seqType[$ii];
		$processPartNum[$processCnt] = $xx;
		#print "******* $processCnt $processName[$processCnt] $processPartNum[$processCnt] $partType[$xx]\n";
		$processSeqSubsysName[$processCnt] = "__PART__";
		$processCnt ++;
	}
	$processSeqEnd[$processSeqCnt] = $processCnt;
}
print "Counted $processCnt parts out of total $ftotal\n";
if($processCnt != $ftotal)
{
	print "Fatal error - not all parts are in processing list!\n";
	%seen = ();
	@missing = ();
	@seen{@processName} = ();
	foreach $item (@xpartName) {
		push (@missing, $item) unless exists $seen{$item};
	}
	print "List of parts not counted:\n";
	foreach  (@missing) {
		my $pt = $partType[$CDS::Parser::parts{$_}];
		if ($pt ne "INPUT" && $pt ne "OUTPUT" && $pt ne "GROUND" 
			&& $pt ne "TERM" && $pt ne "BUSS" && $pt ne "BUSC"
			&& $pt ne "EpicsIn" && $pt ne "CONSTANT" && $pt ne "GOTO") {
			print $_, " ", $partType[$CDS::Parser::parts{$_}], "\n";
		}
	}
	print "Please check the model for missing links around these parts.\n";
	exit(1);
}

# dump sequence to text file
open(SEQDMP, ">" . $partSequenceFile) || die $!;
for($ii=0;$ii<$processCnt;$ii++)
{
	print SEQDMP "$processPartNum[$ii],$processName[$ii]\n";
}
close(SEQDMP);

# check sequence
$seq_test = "$rcg_src_dir/src/python/sequence/main.py";
print "Running sequence test '$seq_test'\n";
if($errcode = system("$seq_test",($compileMessageDir, $ARGV[1])))
{
	$errcode >>= 8;
	$errmsg = "The calculation sequence for $ARGV[1] failed some tests.  A calculation may be out of order, or coverage may not be complete.  See '$ARGV[1]_sequenceErrors.txt' for details. Set IGNORE_SEQUENCE_ERRORS=1 in the environment to allow out-of-order calculations.\nTests returned error code $errcode.";
	if($ENV{"IGNORE_SEQUENCE_ERRORS"})
	{
		print STDERR "*** WARNING $errmsg\n";
	}
	else
	{
		die ("*** ERROR: $errmsg");
	}
}

$fpartCnt = 0;
$inCnt = 0;

# END OF CODE PARSING and LINKED LIST GENERATION**************************************************************************


#// Now have all info necessary to produce the supporting code and text files. \n
#// Start the process of writing files.\n
#//	- Write Epics/real-time data structures to header file.
#//	- Write Epics structs common to all CDS front ends to the .h file.


my $subs = substr($skeleton,5);

print OUTH "#define MAX_FIR    $firCnt\n";
print OUTH "#define MAX_FIR_POLY    $firCnt\n\n";

print OUTH "#define STATESPACE_NUM_PARTS $statespace_num_parts\n\n";

print OUTH "\#define SYSDEF    $systemName\n\n";
print EPICS "\nEPICS CDS_EPICS dspSpace coeffSpace epicsSpace\n\n";
print EPICS "\n\n";

print OUTH "#include \"drv/cdsHardware.h\"\n";
$totalCardCount = $adcCnt + $dacCnt + $boCnt;
print OUTH "extern CDS_CARDS cards_used[" . $totalCardCount . "];\n\n";

print OUTH "#include \"commData3.h\"\n";
print OUTH "#define MODEL_NUM_IPCS_USED $::ipcxCnt\n";
if ( $::ipcxCnt == 0)
{
	print OUTH "extern CDS_IPC_INFO ipcInfo[1];\n\n";
}
else
{
	print OUTH "extern CDS_IPC_INFO ipcInfo[$::ipcxCnt];\n\n";
}

print OUTH "typedef struct CDS_EPICS_IN {\n";
print OUTH "\tint vmeReset;\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_VME_RESET epicsInput.vmeReset int ao 0\n";
print OUTH "\tint ipcDiagReset;\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_IPC_DIAG_RESET epicsInput.ipcDiagReset int ao 0\n";
print OUTH "\tint burtRestore;\n";
print EPICS "BURTRESTORE FEC\_$dcuId\_BURT_RESTORE epicsInput.burtRestore int ai 0\n";
print OUTH "\tint dcuId;\n";
print OUTH "\tint diagReset;\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_DIAG_RESET epicsInput.diagReset int ao 0\n";
print OUTH "\tint overflowReset;\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_OVERFLOW_RESET epicsInput.overflowReset int ao 0\n";

print OUTH "\tint pad1;\n";
if($diagTest > -1)
{
print OUTH "\tint bumpCycle;\n";
print OUTH "\tint bumpAdcRd;\n";
print OUTH "\tint longAdcRd;\n";
}
print OUTH "} CDS_EPICS_IN;\n\n";
print OUTH "typedef struct CDS_EPICS_OUT {\n";
print OUTH "\tint dcuId;\n";
if (0 == length($subs)) {
	print EPICS "OUTVARIABLE  DCU_ID epicsOutput.dcuId int ao 0\n";
} else {
	print EPICS "OUTVARIABLE  \U$subs\E_DCU_ID epicsOutput.dcuId int ao 0\n";
}
print OUTH "\tint tpCnt;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TP_CNT epicsOutput.tpCnt int ao 0\n";

print OUTH "\tint cpuMeterAvg;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_CPU_METER_AVG  epicsOutput.cpuMeterAvg int ao 0\n";

print OUTH "\tint cpuLongCycle;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_CPU_LONG_CYCLE  epicsOutput.cpuLongCycle int ao 0\n";

print OUTH "\tint cpuMeter;\n";

$frate =  $perCycle_us * $clock_div * 0.85;
$brate = $frate;
$mrate = $perCycle_us * $clock_div;
$harate = $mrate * 1.4;
$cpuM = $ifo . ":FEC-" . $dcuId . "_CPU_METER";
print EPICS "OUTVARIABLE FEC\_$dcuId\_CPU_METER epicsOutput.cpuMeter int ao 0 field(HOPR,\"$mrate\") field(LOPR,\"0\") field(HIHI,\"$harate\") field(HHSV,\"MAJOR\") field(HIGH,\"$brate\") field(HSV,\"MINOR\") field(EGU,\"usec\")\n";

print OUTH "\tint cpuMeterMax;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_CPU_METER_MAX epicsOutput.cpuMeterMax int ao 0 field(HOPR,\"$mrate\") field(LOPR,\"0\") field(HIHI,\"$harate\") field(HHSV,\"MAJOR\") field(HIGH,\"$brate\") field(EGU,\"usec\") field(HSV,\"MINOR\")\n";

print OUTH "\tint adcWaitTime;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_WAIT epicsOutput.adcWaitTime int ao 0 field(HOPR,\"$mrate\") field(EGU,\"usec\") field(LOPR,\"0\")\n";

print OUTH "\tint adcWaitMin;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_WAIT_MIN epicsOutput.adcWaitMin int ao 0 field(HOPR,\"$mrate\") field(EGU,\"usec\") field(LOPR,\"0\")\n";

print OUTH "\tint adcWaitMax;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_WAIT_MAX epicsOutput.adcWaitMax int ao 0 field(HOPR,\"$mrate\") field(EGU,\"usec\") field(LOPR,\"0\")\n";

print OUTH "\tint timeErr;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIME_ERR epicsOutput.timeErr int ao 0\n";

if ($edcu) {
print OUTH "\tint timeDiag;\n";
print EPICS "DUMMY FEC\_$dcuId\_TIME_DIAG int ai 0\n";
print OUTH "\tint daqByteCnt;\n";
print EPICS "DUMMY FEC\_$dcuId\_DAQ_BYTE_COUNT int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"4000\") field(HHSV,\"MINOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_EDCU_CHAN_NOCON int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_EDCU_CHAN_CONN int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_EDCU_CHAN_CNT int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_EDCU_DAQ_RESET int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
}elsif ($globalsdf) {
print OUTH "\tint timeDiag;\n";
print EPICS "DUMMY FEC\_$dcuId\_TIME_DIAG int ai 0\n";
print OUTH "\tint datadump;\n";
print EPICS "DUMMY FEC\_$dcuId\_GSDF_DUMP_DATA int ao 0\n";
print OUTH "\tint daqByteCnt;\n";
print EPICS "DUMMY FEC\_$dcuId\_DAQ_BYTE_COUNT int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"4000\") field(HHSV,\"MINOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_GSDF_CHAN_NOCON int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_GSDF_CHAN_CONN int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
print EPICS "DUMMY FEC\_$dcuId\_GSDF_CHAN_CNT int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"1\") field(HHSV,\"MAJOR\")\n";
}elsif ($casdf) {
print OUTH "\tint timeDiag;\n";
print EPICS "DUMMY FEC\_$dcuId\_TIME_DIAG int ai 0\n";
print OUTH "\tint daqByteCnt;\n";
print EPICS "DUMMY FEC\_$dcuId\_DAQ_BYTE_COUNT int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"4000\") field(HHSV,\"MINOR\")\n";
}else{
print OUTH "\tint timeDiag;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIME_DIAG epicsOutput.timeDiag int ao 0\n";
print OUTH "\tint daqByteCnt;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_DAQ_BYTE_COUNT epicsOutput.daqByteCnt int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"4000\") field(HHSV,\"MINOR\")\n";
}

print OUTH "\tint diagWord;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_DIAG_WORD epicsOutput.diagWord int ao 0\n";
print EPICS "\n\n";

print OUTH "\tint statAdc[$adcCnt];\n";
for($ii=0;$ii<$adcCnt;$ii++)
{
	print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_STAT_$ii epicsOutput.statAdc\[$ii\] int ao 0\n";
}

print OUTH "\tint overflowAdc[$adcCnt][32];\n";
for($ii=0;$ii<$adcCnt;$ii++)
{
	for($jj=0;$jj<32;$jj++)
	{
		print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_OVERFLOW_$ii\_$jj epicsOutput.overflowAdc\[$ii\]\[$jj\] int ao 0\n";
	}
}

print OUTH "\tint overflowAdcAcc[$adcCnt][32];\n";
for($ii=0;$ii<$adcCnt;$ii++)
{
	for($jj=0;$jj<32;$jj++)
	{
		print EPICS "OUTVARIABLE FEC\_$dcuId\_ADC_OVERFLOW_ACC_$ii\_$jj epicsOutput.overflowAdcAcc\[$ii\]\[$jj\] int ao 0\n";
	}
}

print OUTH "\tint statDac[$dacCnt];\n";
for($ii=0;$ii<$dacCnt;$ii++)
{
	print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_STAT_$ii epicsOutput.statDac\[$ii\] int ao 0\n";
}

print OUTH "\tint buffDac[$dacCnt];\n";
for($ii=0;$ii<$dacCnt;$ii++)
{
	print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_BUFF_$ii epicsOutput.buffDac\[$ii\] int ao 0\n";
}

print OUTH "\tint overflowDac[$dacCnt][$Dac_common::max_dac_channels];\n";
for($ii=0;$ii<$dacCnt;$ii++)
{
	for($jj=0;$jj<$Dac_common::max_dac_channels;$jj++)
	{
		print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_OVERFLOW_$ii\_$jj epicsOutput.overflowDac\[$ii\]\[$jj\] int ao 0\n";
	}
}

print OUTH "\tint overflowDacAcc[$dacCnt][$Dac_common::max_dac_channels];\n";
for($ii=0;$ii<$dacCnt;$ii++)
{
	for($jj=0;$jj<$Dac_common::max_dac_channels;$jj++)
	{
		print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_OVERFLOW_ACC_$ii\_$jj epicsOutput.overflowDacAcc\[$ii\]\[$jj\] int ao 0\n";
	}
}

print OUTH "\tint dacValue[$dacCnt][$Dac_common::max_dac_channels];\n";
for($ii=0;$ii<$dacCnt;$ii++)
{
	for($jj=0;$jj<$Dac_common::max_dac_channels;$jj++)
	{
		print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_OUTPUT_$ii\_$jj epicsOutput.dacValue\[$ii\]\[$jj\] int ao 0\n";
	}
}


print OUTH "\tint ovAccum;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_ACCUM_OVERFLOW epicsOutput.ovAccum int ao 0\n";

print OUTH "\tint userTime;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_USR_TIME epicsOutput.userTime int ao 0\n";

print OUTH "\tint ipcStat;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_STAT epicsOutput.ipcStat int ao 0\n";

print OUTH "\tint fbNetStat;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_FB_NET_STATUS epicsOutput.fbNetStat int ao 0\n";

# print OUTH "\tint daqByteCnt;\n";
# print EPICS "OUTVARIABLE FEC\_$dcuId\_DAQ_BYTE_COUNT epicsOutput.daqByteCnt int ao 0 field(HOPR,\"4000\") field(LOPR,\"0\") field(HIHI,\"4000\") field(HHSV,\"MINOR\")\n";

print OUTH "\tint dacEnable;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_MASTER_STAT epicsOutput.dacEnable int ao 0\n";

print OUTH "\tint cycle;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_CYCLE_CNT epicsOutput.cycle int ao 0\n";
print OUTH "\tint stateWord;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_STATE_WORD_FE epicsOutput.stateWord int ao 0\n";
print OUTH "\tint epicsSync;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_EPICS_SYNC epicsOutput.epicsSync int ao 0\n";

if($iopModel > -1)
{

    print OUTH "\tint timing_card_temp_c;\n";
    print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_CARD_TEMP_DEG_C epicsOutput.timing_card_temp_c int ao -1 field(HIGH,\"70\") field(HSV,\"MINOR\") field(HIHI,\"80\") field(HHSV,\"MAJOR\")\n";

    print OUTH "\tint dac_temp_c[$dacCnt];\n";
    for($ii=0;$ii<$dacCnt;$ii++)
    {
        print EPICS "OUTVARIABLE FEC\_$dcuId\_DAC_".$ii."_TEMP_DEG_C epicsOutput.dac_temp_c\[$ii\] int ao -1 field(HIGH,\"70\") field(HSV,\"MINOR\") field(HIHI,\"80\") field(HHSV,\"MAJOR\")\n";
    }

    print OUTH "\tint dtTime;\n";
    print OUTH "\tint dacDtTime;\n";
    print OUTH "\tint irigbTime;\n";
    print EPICS "OUTVARIABLE FEC\_$dcuId\_DUOTONE_TIME epicsOutput.dtTime int ao 0\n";
    print EPICS "OUTVARIABLE FEC\_$dcuId\_DUOTONE_TIME_DAC epicsOutput.dacDtTime int ao 0\n";


    # add this as an epics var structure
    # floating point needs to be handled specially
    push @other_epics_vars, CDS::EpicsVariable::new("FEC\_$dcuId\_DUOTONE_TIME_FLOAT", "dtTimeFloat", "double", "ao", 0, 1, {"HSV" => "MAJOR", "LSV" => "MAJOR", "PREC" => "3"});
    push @other_epics_vars, CDS::EpicsVariable::new("FEC\_$dcuId\_DUOTONE_TIME_DAC_FLOAT", "dacDtTimeFloat", "double", "ao", 0, 1, {"HSV" => "MAJOR", "LSV" => "MAJOR", "PREC" => "3"});

    # calculate useconds per cycle
    $usec_per_cyc = (1e6 * $clock_div) / $modelrateHz;

    $irighihi = int(($usec_per_cyc*1.6) + ($::time0_delay_us * 2));
    $irighigh = int(($usec_per_cyc*1.2) + ($::time0_delay_us * 2));
    $iriglow =  int(($usec_per_cyc*0.334) + ($::time0_delay_us * 2));
    print EPICS "OUTVARIABLE FEC\_$dcuId\_IRIGB_TIME epicsOutput.irigbTime int ao 0 field(HIHI,\"$irighihi\") field(HHSV,\"MAJOR\") field(HIGH,\"$irighigh\") field(HSV,\"MINOR\") field(LOW,\"$iriglow\") field(LSV,\"MAJOR\")\n";
# Create EPICS for PCIeTiming card and backplane monitoring
        print OUTH "\tint lptMon[20];\n";
        for($ii=0;$ii<20;$ii++)
        {
	    print EPICS "OUTVARIABLE FEC\_$dcuId\_LPT_MON_$ii epicsOutput.lptMon\[$ii\] int ao 0\n";
        }
        print OUTH "\tint lpt_bp_status;\n";
        print EPICS "OUTVARIABLE FEC\_$dcuId\_IOC_BP_STATUS epicsOutput.lpt_bp_status int ao 0\n";
        print OUTH "\tint lpt_bp_config;\n";
        print EPICS "OUTVARIABLE FEC\_$dcuId\_IOC_BP_CONFIG epicsOutput.lpt_bp_config int ao 0\n";
        print OUTH "\tint lpt_status;\n";
        print EPICS "OUTVARIABLE FEC\_$dcuId\_LPTC_STATUS epicsOutput.lpt_status int ao 0\n";
        print OUTH "\tint pcieInfo[10];\n";
        for($ii=0;$ii<10;$ii++)
        {
	    print EPICS "OUTVARIABLE FEC\_$dcuId\_PCIE_INFO_$ii epicsOutput.pcieInfo\[$ii\] int ao 0\n";
        }
        print OUTH "\tint pcieSlotNum[10];\n";
        for($ii=0;$ii<10;$ii++)
        {
        $irighihi= $ii+ 3;
        $irighigh= $ii+ 2;
        $iriglow =  $ii;
    print EPICS "OUTVARIABLE FEC\_$dcuId\_PCIE_SLOT_$ii epicsOutput.pcieSlotNum\[$ii\] int ao 0 field(HIHI,\"$irighihi\") field(HHSV,\"MAJOR\") field(HIGH,\"$irighigh\") field(HSV,\"MAJOR\") field(LOW,\"$iriglow\") field(LSV,\"MAJOR\")\n";
	    #print EPICS "OUTVARIABLE FEC\_$dcuId\_PCIE_SLOT_$ii epicsOutput.pcieSlotNum\[$ii\] int ao 0 \n";
        }
        print OUTH "\tint statSlot[10];\n";
        for($ii=0;$ii<10;$ii++)
        {
	    print EPICS "OUTVARIABLE FEC\_$dcuId\_PCIE_STAT_$ii epicsOutput.statSlot\[$ii\] int ao 0\n";
        }
}

print OUTH "\tint bioMon[4];\n";
for($ii=0;$ii<4;$ii++)
{
	print EPICS "OUTVARIABLE FEC\_$dcuId\_BIO_MON_$ii epicsOutput.bioMon\[$ii\] int ao 0\n";
}
print OUTH "\tint awgStat;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_AWGTPMAN_STAT epicsOutput.awgStat int ao 0\n";
print OUTH "\tint gdsMon[32];\n";
for($ii=0;$ii<32;$ii++)
{
	print EPICS "OUTVARIABLE FEC\_$dcuId\_GDS_MON_$ii epicsOutput.gdsMon\[$ii\] int ao 0\n";
}

print OUTH "\tint startgpstime;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_START_GPS epicsOutput.startgpstime int ao 0\n";
print OUTH "\tint fe_status;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_FE_STATUS epicsOutput.fe_status int ao 0\n";


print OUTH "\tint disableRemoteIpc;\n";
if ( length($subs) == 0 ) {
    print EPICS "INVARIABLE_NM REMOTE_IPC_PAUSE epicsOutput.disableRemoteIpc int ai 0\n";
} else {
    print EPICS "INVARIABLE_NM \U$subs\E_REMOTE_IPC_PAUSE epicsOutput.disableRemoteIpc int ai 0\n";
}

print OUTH "\tint dacDuoSet;\n";
print EPICS "INVARIABLE_NM FEC\_$dcuId\_DACDT_ENABLE epicsOutput.dacDuoSet int bi 0 field(ZNAM,\"OFF\") field(ONAM,\"ON\")\n";

#IPC Waiting Stats
print OUTH "\tint ipcNumWaitsInSec;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_NUM_LATE epicsOutput.ipcNumWaitsInSec int ao 0\n";

print OUTH "\tint ipcMaxWait_ns;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_MAX_WAIT_NS epicsOutput.ipcMaxWait_ns int ao 0\n";

print OUTH "\tint ipcMaxWaitHold_ns;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_MAX_WAIT_HOLD_NS epicsOutput.ipcMaxWaitHold_ns int ao 0\n";

print OUTH "\tint slowIpcInList;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_SLOW_IN_LIST epicsOutput.slowIpcInList int ao 0\n";

print OUTH "\tint ipcAvgSendTime_ns;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_AVG_SEND_TIME_NS epicsOutput.ipcAvgSendTime_ns int ao 0\n";

print OUTH "\tint ipcMaxSendTime_ns;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_MAX_SEND_TIME_NS epicsOutput.ipcMaxSendTime_ns int ao 0\n";

print OUTH "\tint ipcMaxSendTimeHold_ns;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_MAX_SEND_TIME_HOLD_NS epicsOutput.ipcMaxSendTimeHold_ns int ao 0\n";

print OUTH "\tint IPC_TOTAL_SENDERS;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_TOTAL_SENDERS epicsOutput.IPC_TOTAL_SENDERS int ao 0\n";
print OUTH "\tint IPC_TOTAL_RECEIVERS;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_TOTAL_RECEIVERS epicsOutput.IPC_TOTAL_RECEIVERS int ao 0\n";
print OUTH "\tint IPC_TOTAL_RECV_IN_ERROR;\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_IPC_TOTAL_RECV_IN_ERROR epicsOutput.IPC_TOTAL_RECV_IN_ERROR int ao 0\n";

print EPICS "DUMMY FEC\_$dcuId\_UPTIME_DAY int ao 0\n";
print EPICS "DUMMY FEC\_$dcuId\_UPTIME_HOUR int ao 0\n";
print EPICS "DUMMY FEC\_$dcuId\_UPTIME_MINUTE int ao 0\n";


# The following code is in solely for automated testing.
if($diagTest > -1)
{
print OUTH "\tint timingTest[17];\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_BUMP_CYCLE epicsInput.bumpCycle int ao 0\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_BUMP_ADC epicsInput.bumpAdcRd int ao 0\n";
print EPICS "MOMENTARYNODAQ FEC\_$dcuId\_LONG_ADC epicsInput.longAdcRd int ao 0\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_64K epicsOutput.timingTest[0] int ao 0 field(HIHI,\"62\") field(HHSV,\"MAJOR\") field(LOW,\"60\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_32K epicsOutput.timingTest[1] int ao 0 field(HIHI,\"123\") field(HHSV,\"MAJOR\") field(LOW,\"121\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_16K epicsOutput.timingTest[2] int ao 0 field(HIHI,\"199\") field(HHSV,\"MAJOR\") field(LOW,\"197\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_04K epicsOutput.timingTest[3] int ao 0 field(HIHI,\"489\") field(HHSV,\"MAJOR\") field(LOW,\"487\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_02K epicsOutput.timingTest[4] int ao 0 field(HIHI,\"611\") field(HHSV,\"MAJOR\") field(LOW,\"609\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_64KA epicsOutput.timingTest[5] int ao 0 field(HIHI,\"77\") field(HHSV,\"MAJOR\") field(LOW,\"75\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_32KA epicsOutput.timingTest[6] int ao 0 field(HIHI,\"138\") field(HHSV,\"MAJOR\") field(LOW,\"136\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_16KA epicsOutput.timingTest[7] int ao 0 field(HIHI,\"199\") field(HHSV,\"MAJOR\") field(LOW,\"197\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_04KA epicsOutput.timingTest[8] int ao 0 field(HIHI,\"504\") field(HHSV,\"MAJOR\") field(LOW,\"502\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_02KA epicsOutput.timingTest[9] int ao 0 field(HIHI,\"626\") field(HHSV,\"MAJOR\") field(LOW,\"624\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_64KB epicsOutput.timingTest[10] int ao 0 field(HIHI,\"62\") field(HHSV,\"MAJOR\") field(LOW,\"60\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_32KB epicsOutput.timingTest[11] int ao 0 field(HIHI,\"123\") field(HHSV,\"MAJOR\") field(LOW,\"121\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_16KB epicsOutput.timingTest[12] int ao 0 field(HIHI,\"184\") field(HHSV,\"MAJOR\") field(LOW,\"182\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_04KB epicsOutput.timingTest[13] int ao 0 field(HIHI,\"535\") field(HHSV,\"MAJOR\") field(LOW,\"533\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_02KB epicsOutput.timingTest[14] int ao 0 field(HIHI,\"611\") field(HHSV,\"MAJOR\") field(LOW,\"609\") field(LSV,\"MAJOR\")\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_DELAY epicsOutput.timingTest[15] int ao 0\n";
print EPICS "OUTVARIABLE FEC\_$dcuId\_TIMING_TEST_1PPS epicsOutput.timingTest[16] int ao 0\n";
}

print OUTH "} CDS_EPICS_OUT;\n\n";
if($useWd)
{
print OUTH "typedef struct SEI_WATCHDOG {\n";
print OUTH "\tint trip;\n";
print OUTH "\tint reset;\n";
print OUTH "\tint status\[3\];\n";
print OUTH "\tint senCount[20];\n";
print OUTH "\tint senCountHold[20];\n";
print OUTH "\tint filtMax[20];\n";
print OUTH "\tint filtMaxHold[20];\n";
print OUTH "\tint tripSetF[5];\n";
print OUTH "\tint tripSetR[5];\n";
print OUTH "\tint tripState;\n";
print OUTH "} SEI_WATCHDOG;\n\n";
}
print OUTH "typedef struct \U$systemName {\n";
#//		- Make call to <em>::printHeaderStruct</em> in supporting lib/.pm part files for app specific data structure.
my $header_masks;


# put integers in header file
for($ii=0;$ii<$partCnt;$ii++)
{
    if ($cdsPart[$ii]) {

        $package = "CDS::" . $partType[$ii];
        if (($package)->can("getEpicsVariables")) {
            @epics_vars = ($package."::getEpicsVariables")->($ii);
            @all_epics_vars = (@all_epics_vars, @epics_vars);
            for (@epics_vars) {
                if ($_->isInteger()) {
                    $cdecl = $_->getCDeclaration();
                    print OUTH "\t$cdecl\n";
                    $mask = $_->getCMaskDeclaration();
                    if (length($mask) > 5) {
                        $header_masks .= "\t$mask\n";
                    }
                }
            }
        }
        elsif (($cdsPart[$ii]) && (($partType[$ii] eq "IPCx") || ($partType[$ii] eq "FiltCtrl") || ($partType[$ii] eq "FiltCtrl2") || ($partType[$ii] eq "EpicsBinIn") || ($partType[$ii] eq "DacKill") || ($partType[$ii] eq "DacKillIop") || ($partType[$ii] eq "DacKillTimed") || ($partType[$ii] eq "EpicsMomentary") || ($partType[$ii] eq "EpicsCounter") || ($partType[$ii] eq "Word2Bit") || ($partType[$ii] eq "EpicsOutLong"))) {

            $masks = ("CDS::" . $partType[$ii] . "::printHeaderStruct")->($ii);
            if (length($masks) > 5) {
                $header_masks .= $masks;
            }
        }
    }
}

# handle any non-parts integer epics variables
for (@other_epics_vars) {
    if ($_->isInteger()) {
	$cdecl = $_->getCDeclaration();
	print OUTH "\t$cdecl\n";
	$mask = $_->getCMaskDeclaration();
	if (length($mask) > 5) {
	    $header_masks .= "\t$mask\n";
	}
    }
}

@all_epics_vars = (@all_epics_vars, @other_epics_vars);

# put doubles in header file
for($ii=0;$ii<$partCnt;$ii++)
{
    if ($cdsPart[$ii]) {

        $package = "CDS::" . $partType[$ii];
        if (($package)->can("getEpicsVariables")) {
            @epics_vars = ($package . "::getEpicsVariables")->($ii);
            for (@epics_vars) {
                if ($_->isDouble()) {
                    $cdecl = $_->getCDeclaration();
                    print OUTH "\t$cdecl\n";
                    $mask = $_->getCMaskDeclaration();
                    if (length($mask) > 5) {
                        $header_masks .= "\t$mask\n";
                    }
                }
            }
        }
        elsif (($cdsPart[$ii]) && ($partType[$ii] ne "IPCx") && ($partType[$ii] ne "FiltCtrl") && ($partType[$ii] ne "FiltCtrl2") && ($partType[$ii] ne "EpicsBinIn") && ($partType[$ii] ne "DacKill") && ($partType[$ii] ne "DacKillIop") && ($partType[$ii] ne "DacKillTimed") && ($partType[$ii] ne "EpicsMomentary") && ($partType[$ii] ne "EpicsCounter") && ($partType[$ii] ne "EzCaRead") && ($partType[$ii] ne "EzCaWrite") && ($partType[$ii] ne "EpicsOutLong")) {
            $masks = ("CDS::" . $partType[$ii] . "::printHeaderStruct")->($ii);
            if (length($masks) > 5) {
                $header_masks .= $masks;
            }
        }
    }
}

# handle epics vars not from parts
for (@other_epics_vars) {
    if ($_->isDouble()) {
	$cdecl = $_->getCDeclaration();
	print OUTH "\t$cdecl\n";
	$mask = $_->getCMaskDeclaration();
	if (length($mask) > 5) {
	    $header_masks .= "\t$mask\n";
	}
    }
}

for($ii=0;$ii<$partCnt;$ii++)
{
    if (($cdsPart[$ii]) && (($partType[$ii] eq "EzCaRead") || ($partType[$ii] eq "EzCaWrite"))) {
		  $masks = ("CDS::" . $partType[$ii] . "::printHeaderStruct") -> ($ii);
		  if (length($masks) > 5) {
			$header_masks .= $masks;
		  }
		}
}

# add alarm entries to shared memory structure.  These come after all the channels we want to send in the DAQ
# and won't be sent to the DAQ
print OUTH "\n //begin alarm level variables\n";
for(@all_epics_vars) {
	@cdecls = $_->getAlarmLevelCDeclarations();
	for my $cdecl (@cdecls) {
		print OUTH "\t$cdecl\n";
	}
}

	die "Unspecified \"host\" parameter in cdsParameters block\n" if ($targetHost eq "localhost");

	# Print masks
	#for($ii=0;$ii<$partCnt;$ii++)
	#{
		#if ($cdsPart[$ii] &&  $partType[$ii] eq "EpicsIn" ) {
			#print ::OUTH "\tchar $::xpartName[$ii]_mask;\n";
		#}
	#}
	print OUTH "\n// begin masks\n";
	print OUTH $header_masks;
	print OUTH "} \U$systemName;\n\n";

	print OUTH "\n\n#define MAX_MODULES \t $filtCnt\n";
	$filtCnt *= 10;
	print OUTH "#define MAX_FILTERS \t $filtCnt\n\n";
	print OUTH "typedef struct CDS_EPICS {\n";
	print OUTH "\tCDS_EPICS_IN epicsInput;\n";
	print OUTH "\tCDS_EPICS_OUT epicsOutput;\n";
	print OUTH "\t\U$systemName \L$systemName;\n";
	print OUTH "} CDS_EPICS;\n";
	print OUTH "\#define TARGET_HOST_NAME $targetHost\n";


    if ($edcu) {
        $no_daq = 1;
	    print OUTH "\#define TARGET_RT_FLAG 0\n";
    } else {
	    print OUTH "\#define TARGET_RT_FLAG 1\n";
    }
	print OUTH "\#define TARGET_DAQ_FLAG $no_daq\n";
	print OUTH "\#define TARGET_METER $cpuM\n";

	#//	- Write EPICS database info file for later use by fmseq.pl in generating EPICS code/database.
	#//		- Write info common to all models.
	print EPICS "DAQVAR $dcuId\_LOAD_CONFIG int ao 0\n";
	print EPICS "DAQVAR $dcuId\_CHAN_CNT int ao 0\n";
	print EPICS "DAQVAR $dcuId\_EPICS_CHAN_CNT int ao 0\n";
	print EPICS "DAQVAR $dcuId\_TOTAL int ao 0\n";
	print EPICS "DAQVAR $dcuId\_MSG int ao 0\n";
	print EPICS "DAQVAR  $dcuId\_DCU_ID int ao 0\n";


	#Load EPICS I/O Parts
	#//		- Write part specific info by making call to <em>/lib/.pm</em> part support module.
	for($ii=0;$ii<$partCnt;$ii++)
	{
		if ($cdsPart[$ii]) {
            $package = "CDS::" . $partType[$ii];
            if (($package)->can("getEpicsVariables")) {
                @epics_vars = ($package . "::getEpicsVariables")->($ii);
                for (@epics_vars) {
                    @epics_lines = $_->getEpicsEntries();
                    for my $entry (@epics_lines) {
                        print EPICS "$entry\n";
                    }
                }
            }
            else {
                ("CDS::" . $partType[$ii] . "::printEpics")->($ii);
            }
		}
	}
	for (@other_epics_vars) {
	    @epics_lines = $_->getEpicsEntries();
	    for my $entry (@epics_lines) {
		print EPICS "$entry\n";
	    }
	}
	print EPICS "\n\n";
	print EPICS "systems \U$systemName\-\n";
	if ($plantName ne $systemName) {
		print EPICS "plant \U$plantName\n";
	}

	#$gdsXstart = ($dcuId - 5) * 1250;
	#$gdsTstart = $gdsXstart + 10000;
 	if($modelrateHz <= 4096 ) {
	  $gdsXstart = 20001;
	  $gdsTstart = 30001;
	} else {
	  $gdsXstart = 1;
	  $gdsTstart = 10001;
	}

	$dac_testpoint_names = "";

	$pref = uc(substr($skeleton, 5, length $skeleton));

	for($ii = 0; $ii < $dacCnt; $ii++) {
	   for($jj = 0; $jj < $Dac_common::max_dac_channels; $jj++) {
		if ($pref) {
		  $dac_testpoint_names .= "${pref}_";
		}
		$dac_testpoint_names .= "MDAC". $ii . "_TP_CH" . $jj . " ";
	   }
	}

	#//		- Add extra test point channels.
	print EPICS "test_points $dac_testpoint_names $::extraTestPoints\n";
	#print EPICS "test_points $::extraTestPoints\n";
	if ($::extraExcitations) {
		print EPICS "excitations $::extraExcitations\n";
	}
	#//		- for casdf signal that the CA version of the SDF database sould be generated
	if ($::casdf) {
		print EPICS "sdf_flavor_ca\n";
	}
	#//		- Add GDS info.
    $gdsrate = get_freq();
    if($gdsrate > 524768) {
        $gdsrate = 524768;
    }
	print EPICS "gds_config $gdsXstart $gdsTstart 1250 1250 $gdsNodeId $ifo $gdsrate $dcuId $ifoid\n";
	print EPICS "\n\n";
	close EPICS;

	#//	- Write C source code file.
	# Start process of writing .c file. **********************************************************************
	#//		- Standard opening information.
    print OUT <<END;
// ******* This is a computer generated file *******
// ******* DO NOT HAND EDIT ************************

#include "fe.h"
#include FE_HEADER

END


    if ($::extra_includes) {
        print OUT "//These are passed from 'extra_includes' in the cdsParameters block\n";
        my @headers = split(',', $::extra_includes);
        foreach my $header (@headers) {
            print OUT "#include ${header}\n";
        }
        print OUT "//End of extra_includes\n\n";
    }

    # Define the code cycle rate, TODO FE code also defines this
    print OUT "#define FE_RATE\t$gdsrate\n";

    #Calculate and print IPC rate into HEADER

    print OUTH "#define IPC_RATE\t$ipcrateHz\n\n";
    $ipccycle = $gdsrate / $ipcrateHz;

    print OUTH "//#include \"fm10Gen_types.h\" //We can't include fm10Gen_types.h because we have a circular dependency.\n";
    print OUTH "//So we just forward declare for now. \n";
    print OUTH "typedef struct FILT_MOD FILT_MOD;\n";
    print OUTH "typedef struct COEF COEF;\n";
    print OUTH "\#ifdef __cplusplus\nextern \"C\" {\n\#endif\n"; 
    print OUTH "int feCode(int cycle, double dWord[][32], double dacOut[][$Dac_common::max_dac_channels], FILT_MOD *dsp_ptr, COEF *dspCoeff, CDS_EPICS *pLocalEpics, int feInit);\n\n";
    print OUTH "\#ifdef __cplusplus\n}\n\#endif\n";


	@adcCardNum;
	@dacCardNum;
	$adcCCtr=0;
	$dacCCtr=0;
	# Hardware configuration
	#//		- PCIe Hardware information.
	print OUT "/* Hardware configuration */\n";
	print OUT "CDS_CARDS cards_used[] = {\n";
	for (0 .. $adcCnt-1) {
		print OUT "\t{", $adcType[$_], ",", $adcNum[$_], ",", $adcTimeShift[$_], ", ", $adcRate_sps[$_], "},\n";
		$adcCardNum[$adcCCtr] = substr($adcNum[$_],0,1);
		$adcCCtr ++;
	}
	for (0 .. $dacCnt-1) {
		print OUT "\t{", $dacType[$_], ",", $dacNum[$_], ",0, 65536 },\n";
		$dacCardNum[$dacCCtr] = substr($dacNum[$_],0,1);
		$dacCCtr ++;
	}
	for (0 .. $boCnt-1) {
		print OUT "\t{", $boType[$_], ",", $boNum[$_], ",0", "},\n";
	}
	print OUT "};\n\n";



    my $statespace_json = JSON->new->utf8->pretty(1);
    my $data_to_json = { model_statespace_description=> [] };

	#//		- Includes for User defined function calls.
	# Group includes for function calls at beginning
	for ($ii = 0; $ii < $partCnt; $ii++) {
	   if ($cdsPart[$ii]) {
	      if ($partType[$ii] eq "FunctionCall" ) {
		 ("CDS::" . $partType[$ii] . "::printFrontEndVars") -> ($ii);
	      }

        if ($partType[$ii] eq "Statespace" ) {
            #print "Statespace part: ins: " . $::partInCnt[$::partInNum[$ii][0]] . ", outs: " . $::partOutputs[$::partOutNum[$ii][0]] ."\n";
            push ( @{ $data_to_json->{model_statespace_description} } , 
                    {
                        part_name=>$::xpartName[$ii],
                        part_index=>int($::partnum_to_ss_index_map[$ii]),
                        input_vec_len=>int($::partInCnt[$::partInNum[$ii][0]]),
                        output_vec_len=>int($::partOutputs[$::partOutNum[$ii][0]])
                    } );
        }

	   }

	}
    open(STATESPACE, ">$statespaceConfigFile") || die "cannot open statespace config file () for writing";
    print STATESPACE $statespace_json->encode($data_to_json) . "\n";
    close STATESPACE;



	#//		- Variable definitions.
	printVariables();

	#//		- Main user code subroutine call opening information.
	#//			- <em>feCode(
	#//				int cycle, double dWord[][32],double dacOut[][$Dac_common::max_dac_channels],
	#//				FILT_MOD *dsp_ptr, COEF *dspCoeff, CDS_EPICS *pLocalEpics,int feInit)</em>
	print OUT <<END;

int feCode(int cycle, 
			  double dWord[][32],
			  double dacOut[][$Dac_common::max_dac_channels],
              FILT_MOD *dsp_ptr,      /* Filter Mod variables */
              COEF *dspCoeff,         /* Filter Mod coeffs */
              CDS_EPICS *pLocalEpics, /* EPICS variables */
              int feInit)     /* Initialization flag */
{

int ii, dacFault;
ii = 0; //Use so IOP models don't have a warning, some parts count on this being declared so we need it
dacFault = 1; // Enabling DAC outs for those who don't have DAC KILL WD, 1 is normal no error case

if(feInit)
{
END
;

	#//		- Variable declarations and initializations in subroutine which take place on first call at runtime.
	#//			- For most parts, added by call to <em>::frontEndInitCode</em> in /lib/.pm support module.
	for($ii=0;$ii<$partCnt;$ii++)
	{
		# INPUT partType is excluded here, either because lib/INPUT.pm does not exist
		# (on case-sensitive FS), or by explicit test (on case-insensitive FS)
		if ( -e "lib/$partType[$ii].pm" && $partType[$ii] ne "INPUT" ) {
		   print OUT ("CDS::" . $partType[$ii] . "::frontEndInitCode") -> ($ii);
		}	

		if($partType[$ii] eq "GROUND") {
		    if ($groundInit == 0)  {                                       # =+=  MA  =+=
			print OUT "ground = 0\.0;\n";                              # =+=  MA  =+=
			$groundInit++;                                             # =+=  MA  =+=
		    }                                                              # =+=  MA  =+=
		}
		if($partType[$ii] eq "CONSTANT") {
			print OUT "\L$xpartName[$ii] = (double)$partInputs[$ii];\n";
		}
	}
	print OUT "\} else \{\n";

	#//		- Main processing thread.
	# IPCx PART CODE
	#
	#//			- All IPCx data receives are to occur first in the processing loop
	#
	if ($ipcxCnt > 0 ) {
	   print OUT "\nif((cycle % ADC_MEMCPY_RATE) == 0) {\n";
       print OUT "    pLocalEpics->epicsOutput.IPC_TOTAL_RECV_IN_ERROR = commData3Receive(myIpcCount, ipcInfo, timeSec , (cycle / ADC_MEMCPY_RATE));\n";
       print OUT "}\n\n";
	}
	# END IPCx PART CODE

	#print "*****************************************************\n";

	  &printSubsystem(".");

	sub printSubsystem {
my ($subsys) = @_;

$ts = 0;
$xx = 0;
$do_print = 0;


#//			- Produce code for all parts in the linked list.
for($xx=0;$xx<$processCnt;$xx++) 
{
	if($xx == $processSeqEnd[$ts]) {
		if ($do_print && ($processSeqType{$cur_sys_name} eq "SUBSYS")) {
		    print OUT "\n\/\/End of subsystem   $cur_sys_name **************************************************\n\n\n";
		}
		$do_print = 0;
	}
	if($xx == $processSeqStart[$ts])
	{
		if ($processSeqSubsysName[$xx] =~ /$subsys/) {
		  $do_print = 1; 
		  $cur_sys_name = $processSeqSubsysName[$xx];
		  if ($processSeqType{$cur_sys_name} eq "SUBSYS") {
		    print OUT "\n\/\/Start of subsystem $cur_sys_name **************************************************\n\n";
		  }
		}
		$ts ++;
	}

	if (! $do_print)  { next; };
	$mm = $processPartNum[$xx];
	#print "looking for part $mm type=$partType[$mm] name=$xpartName[$mm]\n";
	$inCnt = $partInCnt[$mm];
	for($qq=0;$qq<$inCnt;$qq++)
	{
		$indone = 0;
		if ( -e "lib/$partInputType[$mm][$qq].pm" ) {
		  require "lib/$partInputType[$mm][$qq].pm";
	  	  $fromExp[$qq] = ("CDS::" . $partInputType[$mm][$qq] . "::fromExp") -> ($mm, $qq);
	    	  $indone = $fromExp[$qq] ne "";
		}

		if($indone == 0)
		{
			$from = $partInNum[$mm][$qq]; #part number for input $qq
			$fromExp[$qq] = "\L$xpartName[$from]";
		}

		# Avoid a bunch of ground signals and combine into one.
                if ($fromExp[$qq] =~ /ground/)  {
                   $fromExp[$qq] = "ground";
                }
	}

	# Create the FE code for this part.
        if ( -e "lib/$partType[$mm].pm" ) {
	  	  print OUT ("CDS::" . $partType[$mm] . "::frontEndCode") -> ($mm);
	}	

	# ******** GROUND INPUT ********************************************************************
	if(($partType[$mm] eq "GROUND") && ($partUsed[$mm] == 0))
	{
	   #print "Found GROUND $xpartName[$mm] in loop\n";
	}

	# ******** DELAY ************************************************************************
	if($partType[$mm] eq "DELAY")
	{
		$calcExp = "\L$xpartName[$mm]";
		$calcExp .= " = ";
		$calcExp .= $fromExp[0];
		$calcExp .= ";\n";
		$unitDelayCode .= "$calcExp";
	}

print OUT "\n";
}
}

#//			- Add all UNIT DELAY part code.
print OUT "    // Unit delays\n";
print OUT "$unitDelayCode";

# IPCx PART CODE
# The actual sending of IPCx data is to occur
# as the last step of the processing loop
#
if ($ipcxCnt > 0) {
   print OUT "    // All IPC outputs\n";
   print OUT "      if(!cycle && pLocalEpics->epicsInput.ipcDiagReset) pLocalEpics->epicsInput.ipcDiagReset = 0;\n";

   # if clock_div is greater than than the IPC rate,
   # we still need to send at ipcrate.
   # should we even allow that possibility?

   my $send_cycle = $clock_div - 1;
   if( $ipccycle < $clock_div ) {
       $send_cycle = $ipccycle - 1;
   }

   print OUT "\n    if((cycle % $ipccycle) == $send_cycle) commData3Send(myIpcCount, ipcInfo, timeSec, (cycle / $ipccycle));\n\n";
}
# END IPCx PART CODE

print OUT "  }\n";
print OUT "  return(dacFault);\n\n";
print OUT "}\n";
if(($remoteGpsPart != 0) && ($remoteGPS != 0))
{
print "RGPS DIAG **********************************\n";
print "\tPart number is $remoteGpsPart\n";
	print OUT "unsigned int remote_time(CDS_EPICS *pLocalEpics) {\n\treturn ";
	$calcExp = ("CDS::EzCaRead::remoteGps") -> ($remoteGpsPart);
	print "$calcExp \n";
	print OUT "$calcExp;\n}\n";

}


if($partsRemaining != 0) {
	print WARNINGS "WARNING -- NOT ALL PARTS CONNECTED !!!!\n";
for($ii=0;$ii<$partCnt;$ii++)
{
	if($partUsed[$ii] == 0)
	{
	print "$ii $xpartName[$ii] $partOutCnt[$ii] $partUsed[$ii]\n";
	}
}
}

close IN;
close OUT;


close OUTD;

#// Write out the User Space Code Here (Just copy it, same code file for both)
copy($modelCodeKernFilepath, $modelCodeUspFilepath) or die "copy failed: $! : ";
	

#//	- Write C code MAKEFILE
require "lib/createKernelModuleBuildEnv.pm";
("CDS::KernelMakefileUtils::createKernelMakefiles") -> ($modelCodeKernDir);
#//	- Write User Space C code MAKEFILE
require "lib/createUserModuleBuildEnv.pm";
("CDS::USP_Cmake_Utils::createUSP_CmakeFiles") -> ($modelCodeUspDir);
#//	- Write EPICS code MAKEFILE
require "lib/createEpicsMakefile.pm";
("CDS::EpicsMakefile::createEpicsMfile") -> ($meFile);



#//	- Write FOTON filter definition file.
# Create Foton filter file (with header)
$jj = $filtCnt / 40; #Div by 40 because we are putting 4 on each line
$jj ++;
#print OUTG "$jj lines to print\n";
my $filtFile = $configFilesDir . "/$ifo" . uc($skeleton) . "\.txt";
open(OUTG, ">" . $filtFile) || die "cannot open  $filtFile file for writing";
print OUTG "# FILTERS FOR ONLINE SYSTEM\n".
	"#\n".
	"# Computer generated file: DO NOT EDIT\n".
	"# SAMPLING RATE " . get_freq() . "\n" .
	"#\n";

for($ii=0;$ii<$jj;$ii++)
{
	$kk = $ii * 4;
	print OUTG "\# MODULES $filterName[$kk] ";
	$kk ++;
	print OUTG "$filterName[$kk] ";
	$kk ++;
	print OUTG "$filterName[$kk] ";
	$kk ++;
	print OUTG "$filterName[$kk]\n";
}

my $sampling_rate = get_freq();
$jj  = $filtCnt / 10;

for($ii=0;$ii<$jj;$ii++) {
print OUTG <<EOF;
################################################################################
#### $filterName[$ii]
#################################################################################
## SAMPLING $filterName[$ii] $sampling_rate
####                                                                          ###
#

EOF
}
close OUTG;

#
# Write new filter description JSON file 
#
my $filters_json = JSON->new->utf8->pretty(1);
my $filters_to_json = { model_filters_description=> [] };

open(FILTER_JSON_OUT, ">" . $newFilterConfigFile) || die "cannot open  $newFilterConfigFile file for writing";
for($ii=0; $ii < $filtCnt / 10; $ii++)
{
    push ( @{ $filters_to_json->{model_filters_description} } , 
            {
                filter_name=>$filterName[$ii],
                filter_index=>int($ii),
            } );
}
print FILTER_JSON_OUT $filters_json->encode($filters_to_json) . "\n";
close FILTER_JSON_OUT;

#//	- Generate standard set of MEDM screen files.
# Take care of generating Epics screens *****************************************************

# Used to develop sed command to allow Filter module screens to link generic FILTERALH screen.
@rcg_util_path = split('/', $ENV{"RCG_SRC_DIR"});
my $ffmedm = "";
foreach $i (@rcg_util_path) {
$ffmedm .= $i;
$ffmedm .= "\\/";
}

eval mkpath($epicsScreensDir, { verbose => 0, mode => 0755 });
if ($@) {
    die "Failed to make path $epicsScreensDir";
}

my $sysname = "FEC";
my $medmDir = $target . "/medm/" . $skeleton . "/";
$sed_arg = "s/SITE_NAME/$ifo/g;s/CONTROL_SYSTEM_SYSTEM_NAME/" . uc($skeleton) . "/g;s/SYSTEM_NAME/" . uc($sysname) . "/g;s/GDS_NODE_ID/" . $gdsNodeId . "/g;";
$sed_arg .= "s/LOCATION_NAME/$lsite/g;";
$sed_arg .= "s/DCU_NODE_ID/$dcuId/g;";
$sysname = uc($skeleton);
$sed_arg .= "s/FBID/$sysname/g;";
$sed_arg .= "s/MEDMDIR/$skeleton/g;";
$sed_arg .= "s/IFO_LC/$lifo/g;";
$sed_arg .= "s/MODEL_LC/$skeleton/g;";
$sed_arg .= "s|TARGET_MEDM|$medmDir|g;";
$sed_arg .= "s/RCGDIR/$ffmedm/g;";
$sed_arg .= "s/X2/$ifo/g;";
$sed_arg .= "s/FEC-110/FEC-$dcuId/g;";
$sed_arg .= "s/FEC-114/FEC-$dcuId/g;";
$mxpt = 215;
$mypt = 172;
$mbxpt = 32 + $mxpt;
$mbypt = $mypt + 1;
$dacMedm = 0;
$totalMedm = $adcCnt + $dacCnt;
print "Found $adcCnt ADC modules part is $adcPartNum[0]\n";
print "Found $dacCnt DAC modules part is $dacPartNum[0]\n";


if($::iopModel)
{
#system("cp $rcg_src_dir/src/epics/util/IOP_IO_STATUS.adl IOP_IO_STATUS.adl");
system("cat $rcg_src_dir/src/epics/util/IOP_IO_STATUS.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_IOP_IO_STATUS.adl");
}
#//		-  Generate SDF Restore Screen
#system("cp $rcg_src_dir/src/epics/util/SDF_RESTORE.adl SDF_RESTORE.adl");
system("cat $rcg_src_dir/src/epics/util/SDF_RESTORE.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_SDF_RESTORE.adl");
#//		-  Generate SDF Save Screen
#system("cp $rcg_src_dir/src/epics/util/SDF_SAVE.adl SDF_SAVE.adl");
system("cat $rcg_src_dir/src/epics/util/SDF_SAVE.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_SDF_SAVE.adl");
#//		-  Generate GDS Table Screen
#system("cp $rcg_src_dir/src/epics/util/GDS_TABLE.adl GDS_TABLE.adl");
system("cat $rcg_src_dir/src/epics/util/GDS_TABLE.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_GDS_TABLE.adl");

#//		-  Generate SDF Table Screen
if ($::casdf) {
#system("cp $rcg_src_dir/src/epics/util/SDF_TABLE_CA.adl SDF_TABLE.adl");
system("cat $rcg_src_dir/src/epics/util/SDF_TABLE_CA.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_SDF_TABLE.adl");
} else {
#system("cp $rcg_src_dir/src/epics/util/SDF_TABLE.adl SDF_TABLE.adl");
system("cat $rcg_src_dir/src/epics/util/SDF_TABLE.adl | sed '$sed_arg' > $epicsScreensDir/$sysname" . "_SDF_TABLE.adl");
}

my $cur_subsys_num = 0;

# Determine whether passed name need to become a _ name
# i.e. whether the system/subsystem parts need to excluded 
sub is_top_name {
   ($_) =  @_;
   @d = split(/_/);
   $d = shift @d;
   #print "$d @top_names\n";
   foreach $item (@top_names) {
        #print  "   $item $d\n";
        if ($item eq $d) { return 1; }
   }
   return 0;
};


foreach $cur_part_num (0 .. $partCnt-1) {
	if ($cur_part_num >= $subSysPartStop[$cur_subsys_num]) {
		$cur_subsys_num += 1;
	}
	if ($partType[$cur_part_num] =~ /Matrix$/) {
		my $outcnt = $::matOuts[$cur_part_num]; #$partOutCnt[$cur_part_num];
		my $incnt = $partInCnt[$cur_part_num];
		if ($partType[$cur_part_num] eq "MuxMatrix") {
			# MuxMatrix uses mux and demux parts 
			$outcnt = $partOutputs[$partOutNum[$cur_part_num][0]];
			$incnt = $partInCnt[$partInNum[$cur_part_num][0]];
		}
		if ($partType[$cur_part_num] eq "FiltMuxMatrix") {
			# FiltMuxMatrix uses mux and demux parts
			$outcnt = $partOutputs[$partOutNum[$cur_part_num][0]];
			$incnt = $partInCnt[$partInNum[$cur_part_num][0]];
		}
		if ($partType[$cur_part_num] eq "RampMuxMatrix") {
                        # RampMuxMatrix uses mux and demux parts
                        $outcnt = $partOutputs[$partOutNum[$cur_part_num][0]];
                        $incnt = $partInCnt[$partInNum[$cur_part_num][0]];
                }
		my $basename = $partName[$cur_part_num];
		if ($partSubName[$cur_part_num] ne "") {
			$basename = $partSubName[$cur_part_num] . "_" . $basename;
		}

		$collabels = commify_series(@{$partInput[$cur_part_num]});

		# This doesn't work so well if output has branches
		#$rowlabels = commify_series(@{$partOutput[$cur_part_num]});
		$rowlabels = "";

        	for (0 .. $::partOutCnt[$cur_part_num]-1) {
           	  $::portUsed[$_] = 0;
        	}
        
        	for (0 .. $::partOutCnt[$cur_part_num]-1) {
          	  my $fromPort = $::partOutputPortUsed[$cur_part_num][$_];
          	  if ($::portUsed[$fromPort] == 0) {
            	    $::portUsed[$fromPort] = 1; 
		    if ($rowlabels) { $rowlabels .= ",";}
		    $rowlabels .= $partOutput[$cur_part_num][$_];
          	  }
        	}


		if (is_top_name($basename)) {

		  my $tn = top_name_transform($basename);
		  my $basename1 = $ifo . ":" . $tn . "_";
		  my $filtername1 = $ifo . $basename;
		  if ($partType[$cur_part_num] eq "FiltMuxMatrix") {
		    my $subDirName = "$epicsScreensDir/$ifo" . "$basename";
		    mkdir $subDirName;
		    system("$rcg_src_dir/src/epics/util/mkfiltmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 --filterbase=$filtername1 > $epicsScreensDir/$ifo" . $basename . ".adl");
		    for ($row = 1; $row < $outcnt+1; $row ++) {
		      for ($col = 1; $col < $incnt+1; $col ++) {
			my $filt_name = "$partName[$cur_part_num]" . "_" . "$row" . "_" . "$col";
			print "FILTER Part $filt_name $partType[$cur_part_num] input partInput=$partInput[$cur_part_num][0] type='$partInputType[$cur_part_num][0]' \n";
		       	if ($partSubName[$cur_part_num] ne "") {
			    $filt_name = $partSubName[$cur_part_num] . "_" . $filt_name;
			}
			my $sys_name = uc($skeleton);
			my $sargs;
			
			my $tfn = top_name_transform($filt_name);
			my $nsys = system_name_part($tfn);
			$sargs = "s/CONTROL_SYSTEM_SYSTEM_NAME/" . uc($skeleton) . "/g;";
			$sargs .= "s/SITE_NAME/$ifo/g;s/SYSTEM_NAME/" . $nsys . "/g;";
                        $sargs .= "s/LOCATION_NAME/$lsite/g;";
			$sargs .= "s/FILTERNAME/$tfn/g;";
			$sargs .= "s/RCGDIR/$ffmedm/g;";
			$sargs .= "s/DCU_NODE_ID/$dcuId/g";
			system("cat $rcg_src_dir/src/epics/util/FILTER.adl | sed '$sargs' > $subDirName/$ifo" . $filt_name . ".adl");
		      }
		    }
		  } elsif ($partType[$cur_part_num] eq "RampMuxMatrix") {
			system("$rcg_src_dir/src/epics/util/mkrampmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 > $epicsScreensDir/$ifo" . $basename . ".adl");
		  } else {
		    system("$rcg_src_dir/src/epics/util/mkmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 > $epicsScreensDir/$ifo" . $basename . ".adl");
		  }

	  
		} else {
		  $sysname = substr($sysname, 2, 3);
		  my $basename1 = $ifo . ":" .$sysname ."-" . $basename . "_";
		  my $filtername1 = $ifo . $sysname . "_" . $basename;
		  #print "Matrix $basename $incnt X $outcnt\n";
		  if ($partType[$cur_part_num] eq "FiltMuxMatrix") {
		    my $subDirName = "$epicsScreensDir/$ifo" . "$sysname" . "_" . "$basename";
		    mkdir $subDirName;
		    system("$rcg_src_dir/src/epics/util/mkfiltmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 --filterbase=$filtername1 > $epicsScreensDir/$ifo$sysname" . "_" . $basename . ".adl");
                    for ($row = 1; $row < $outcnt+1; $row ++) {
		      for ($col = 1; $col < $incnt+1; $col ++) {
			my $filt_name = "$partName[$cur_part_num]" . "_" . "$row" . "_" . "$col";
			print "FILTER Part $filt_name $partName[$cur_part_num] $partType[$cur_part_num] input partInput=$partInput[$cur_part_num][0] type='$partInputType[$cur_part_num][0]' \n";
			if ($partSubName[$cur_part_num] ne "") {
			    $filt_name = $partSubName[$cur_part_num] . "_" . $filt_name;
			}
			my $sargs;

			$sargs = $sed_arg . "s/FILTERNAME/$sysname-$filt_name/g;";
			$sargs .= "s/RCGDIR/$ffmedm/g;";
			$sargs .= "s/DCU_NODE_ID/$dcuId/g";
			system("cat $rcg_src_dir/src/epics/util/FILTER.adl | sed '$sargs' > $subDirName/$ifo$sysname" . "_" . $filt_name . ".adl");
		      }
		    }
		  } elsif ($partType[$cur_part_num] eq "RampMuxMatrix") {
			system("$rcg_src_dir/src/epics/util/mkrampmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 > $epicsScreensDir/$ifo$sysname" . "_" . $basename . ".adl");
		  } else {
		    system("$rcg_src_dir/src/epics/util/mkmatrix.pl --cols=$incnt --collabels=$collabels --rows=$outcnt --rowlabels=$rowlabels --chanbase=$basename1 > $epicsScreensDir/$ifo$sysname" . "_" . $basename . ".adl");
		  }
		}
	}
	if ((($partType[$cur_part_num] =~ /^Filt/)
	     && (not ($partType[$cur_part_num] eq "FiltMuxMatrix")))
	    || ($partType[$cur_part_num] =~ /^InputFilt/)
	    || ($partType[$cur_part_num] =~ /^InputFilter1/)) {
		my $filt_name = $partName[$cur_part_num];
	if ($partInputType[$cur_part_num][0] eq "Adc") {
		#exit(1);
	}
		if ($partSubName[$cur_part_num] ne "") {
			$filt_name = $partSubName[$cur_part_num] . "_" . $filt_name;
		}
		my $sys_name = uc($skeleton);
		my $sargs;
		$sysname = uc($skeleton);
		if (is_top_name($filt_name)) {
			my $tfn = top_name_transform($filt_name);
			my $nsys = system_name_part($tfn);
			$sargs = "s/CONTROL_SYSTEM_SYSTEM_NAME/" . uc($skeleton) . "/g;";
			$sargs .= "s/SITE_NAME/$ifo/g;s/SYSTEM_NAME/" . $nsys . "/g;";
                        $sargs .= "s/LOCATION_NAME/$lsite/g;";
			$sargs .= "s/FILTERNAME/$tfn/g;";
			$sargs .= "s/RCGDIR/$ffmedm/g;";
			$sargs .= "s/DCU_NODE_ID/$dcuId/g";
			if ($partType[$cur_part_num] =~ /^InputFilter1/) {
				system("cat INPUT_FILTER1.adl | sed '$sargs' > $epicsScreensDir/$ifo" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^InputFilt/) {
				system("cat $rcg_src_dir/src/epics/util/INPUT_FILTER.adl | sed '$sargs' > $epicsScreensDir/$ifo" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^FiltCtrl2/) {
				system("cat $rcg_src_dir/src/epics/util/FILTER_CTRL_2.adl | sed '$sargs' > $epicsScreensDir/$ifo" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^FiltCtrl/) {
				system("cat $rcg_src_dir/src/epics/util/FILTER_CTRL.adl | sed '$sargs' > $epicsScreensDir/$ifo" . $filt_name . ".adl");
			} else {
				system("cat $rcg_src_dir/src/epics/util/FILTER.adl | sed '$sargs' > $epicsScreensDir/$ifo" . $filt_name . ".adl");
			}
		} else {
		  	$sys_name = substr($sys_name, 2, 3);
			$sargs = $sed_arg . "s/FILTERNAME/$sys_name-$filt_name/g;";
			$sargs .= "s/RCGDIR/$ffmedm/g;";
			$sargs .= "s/DCU_NODE_ID/$dcuId/g";
			if ($partType[$cur_part_num] =~ /^InputFilter1/) {
				system("cat INPUT_FILTER1.adl | sed '$sargs' > $epicsScreensDir/$sysname" . "_" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^InputFilt/) {
				system("cat $rcg_src_dir/src/epics/util/INPUT_FILTER.adl | sed '$sargs' > $epicsScreensDir/$sysname" . "_" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^FiltCtrl2/) {
				system("cat $rcg_src_dir/src/epics/util/FILTER_CTRL_2.adl | sed '$sargs' > $epicsScreensDir/$sysname" . "_" . $filt_name . ".adl");
			} elsif ($partType[$cur_part_num] =~ /^FiltCtrl/) {
				system("cat $rcg_src_dir/src/epics/util/FILTER_CTRL.adl | sed '$sargs' > $epicsScreensDir/$sysname" . "_" . $filt_name . ".adl");
			} else {
				system("cat $rcg_src_dir/src/epics/util/FILTER.adl | sed '$sargs' > $epicsScreensDir/$sysname" . "_" . $filt_name . ".adl");
			}
		}
	}
		  $sysname = uc($skeleton);
}

# ******************************************************************************************
#//		- GENERATE SORTED ADC LIST FILE
$adcFile = $partConnectFileFilteredADC; 
$adcFileSorted = $configFilesDir . "/adcListSorted\.txt";
system ("sort $adcFile -k 1,1n -k 2,2n > $adcFileSorted");

# ******************************************************************************************
#//		- GENERATE IPC SCREENS
	("CDS::IPCx::createIpcMedm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$ipcxCnt);
# ******************************************************************************************
#//		- GENERATE GDS_TP SCREEN
	require "lib/medmGenGdsTp.pm";
	my $medmTarget = "$target/medm";
	my $scriptTarget = "$target/chans/tmp/$sysname\.diff";
	my $scriptArgs = "-s $lsite -i $lifo -m $skeleton -d $dcuId &";
    my $ioptimediag = $virtualiop + $no_sync;
	("CDS::medmGenGdsTp::createGdsMedm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$scriptTarget,$scriptArgs,$adcCnt,$dacCnt,$iopModel,$ioptimediag,$daq_prefix,\@dacType,\@adcType);
	require "lib/medmGenStatus.pm";
	("CDS::medmGenStatus::createStatusMedm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$scriptTarget,$scriptArgs,$adcCnt,$dacCnt,$iopModel,@dacType);


# ******************************************************************************************
#//		- GENERATE ADC SCREENS
# Open the diags2.txt file, which contains list of ADC connections.
open(my $fh, $adcFile)
  or die "Could not open file";

# Need the 3 letter system name to complete EPICS channel names.
$sysname = uc($skeleton);
$sname = substr($sysname,2,3);
@adcScreen;
$ii = 0;
$jj = 0;
while (my $line = <$fh>) {
        chomp($line);
        my @word = split /\t/,$line;
        $ii = $word[0];
        $jj = $word[1];
	$adcSname = $ifo . "\:$sname-" . $word[2];
	if (is_top_name($word[2])) {
                  my $tn = top_name_transform($word[2]);
                  $adcSname = $ifo . "\:" . $tn;
        } 
	# If this is a Filter type part, need to add INMON to get EPICS channel 
	if (($word[3] =~ /^Filt/)
	     && (not ($word[3] eq "FiltMuxMatrix"))) {
		$adcSname .= "_INMON";
	}
	# Only place Filter and EpicsOut type parts in the list
	if (($word[3] =~ /^Filt/ && $word[3] ne "FiltMuxMatrix")
		|| $word[3] eq "EpicsOut") {
        	$adcScreen[$ii][$jj] = $adcSname;
	}
}
close($fg);

for($ii=0;$ii<$adcCnt;$ii++)
{
   ("CDS::Adc::createAdcMedm") -> ($epicsScreensDir,$sysname,$iopModel,$ifo,$dcuId,$medmTarget,$ii,@adcScreen);
}
# ******************************************************************************************
#//		- GENERATE DAC SCREENS
#TODO: Gen screen for LIGO 32 chan dac
for($ii=0;$ii<$dacCnt;$ii++)
{
	if ($dacType[$ii] eq "GSC_16AO16") {
    	("CDS::Dac::createDac16Medm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$ii);
   	} elsif ($dacType[$ii] eq "GSC_20AO8") {
    	("CDS::Dac20::createDac20Medm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$ii);
	} elsif ($dacType[$ii] eq "LIGO_28AO32") {
		("CDS::Dacligo28::createMedm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$ii);
   	} elsif ($dacType[$ii] eq "GSC_18AO8" ) {
		("CDS::Dac18::createDac18Medm") -> ($epicsScreensDir,$sysname,$ifo,$dcuId,$medmTarget,$ii);
   	}
	else {
		die "Unsupported DAC type: $dacType[$ii]\n";
	}
}

# ******************************************************************************************
#//		- GENERATE caQtDM SCREENS

if ( system("which adl2ui") == 0 )
{

    eval mkpath($caqtdmTempDir, { verbose => 0, mode => 0755 });
    if ($@) {
        die "Failed to make path $caqtdmTempDir";
    }


    opendir my $dh, $epicsScreensDir;
    while (my $cf = readdir $dh) {
       if($cf =~ m/.adl/) {
        my ($fbase,$fext) = split '\.',$cf;
        system("cp -f $epicsScreensDir/$cf $caqtdmTempDir" );
        $ui_output = "$caqtdmScreensDir/$fbase" . ".ui";
        system("cd $caqtdmTempDir && adl2ui $cf");
        system("cd $caqtdmTempDir && cp -f $fbase.ui $ui_output");
        system("cd $caqtdmTempDir && rm -f $fbase.ui $cf");
       }
    }
}
else #No caQtDM installed skip
{
    print WARNINGS "\ncaqtdm is not installed, skipping caQtDM screen generation.\n\n";
}

close WARNINGS;


#//	-  Print source file names into a file
#
open(OUT,">$modelEpicsCodeDir/sources.\L$sysname\E") || die "cannot open \"$modelEpicsCodeDir/sources.$sysname\" file for writing ";
print OUT join("\n", @sources), "\n";
close OUT;
print OUTH "\#endif //".$header_guard_string."\n";
close OUTH;

#//	
#// \n \b SUBROUTINES ******************************************************************************\n\n
#// \b sub \b remove_subsystem \n
#// Remove leading subsystems name \n\n
sub remove_subsystem {
        my ($s) = @_;
        return substr $s, 1 + rindex $s, "_";
}

#// \b sub \b debug \n
#// Print debug message \n
#// Example: \n
#// debug (0, "debug test: openBrace=$openBrace"); \n\n
#
sub debug {
  if ($dbg_level > shift @_) {
	print @_, "\n";
  }
}
#// \b sub \b get_freq \n
#// Determine user code sample rate \n\n
sub get_freq {
    return $modelrateHz;
}

#// \b sub \b init_vars \n
#// Initialize global variables used by the model parser \n\n
sub init_vars {
# Global variables set by parser
$epics_fields[0] = undef; # list of lists; for each part number, epics fields
$extraTestPoints;	# a list of test point names not related to filters
$extraTpcount = 0;		# How many extra TPs we have
@top_names; 	# array of top-level subsytem names marked with "top_names" tag
$systemName = "";	# model name
$adcCnt = 0;	# Total A/D converter boards
$adcType[0] = 0;	# A/D board types
$adcNum[0] = 0;	# A/D board numbers, sequential
$adcTimeShift[0] = 0; # A/D time shift: number of reads per cycle to get from the previous cycle.
$adcRate_sps[0] = 0; # A/D sample rate, samples per second
$dacCnt = 0;	# Total D/A converter boards
$dacType[0] = 0;	# D/A board types
$dacNum[0] = 0;	# D/A board numbers, sequential
$boCnt = 0;	# Total binary output boards
$boType[0] = 0;	# Binary output board types
$boNum[0] = 0;	# Binary output board numbers, sequential
$card2array[0] = 0;
$bo64Cnt = 0;
$bi64Cnt = 0;
$nonSubCnt = 0; # Total of non-sybsystem parts found in the model
$blockDescr[0] = undef;

# Keeps non-subsystem part numbers
$nonSubPart[0] = 0;	# $nonSubPart[0 .. $nonSubCnt]

$partCnt = 0;	# Total parts found in the simulink model

# Element is set to one for each CDS parts
$cdsPart[0] = 0;	# $cdsPart[0 .. $partCnt]

$ppFIR[0] = 0;          # Set to one for PPFIR filters

# Total number of inputs for each part
# i.e. how many parts are connected to it with lines (branches)
$partInCnt[0] = 0;	# $partInCnt[0 .. $partCnt]
# Source part name (a string) for each part, for each input
# This shows which source part is connected to that input
$partInput[0][0] = "";	# $partInput[0 .. $partCnt][0 .. $partInCnt[0]]
# Source port number
# This shows which source parts' port is connected to each input
$partInputPort[0][0] = 0;	# $partInputPort[0 .. $partCnt][0 .. $partInCnt[$_]]
$partInputs[0] = 0;		# Stores 'Inputs' field of the part declaration in SUM part, 'Operator' in RelationaOperator part, 'Value' Constant part, etc
$partInputs1[0] = 0;		# Same as $partInputs, i.e. extra part parameter, used with Saturation part

$partOutputs[0] = 0; 	# Stores 'Outputs' field value for some parts
# Total number of outputs for each part
# i.e. how many parts are connected with lines (branches) to it
$partOutCnt[0] = 0;	# $partOutCnt[0 .. $partCnt]
# Destination part name (a string) for each part, for each output
# Shows which destination part is connected to that output
$partOutput[0][0] = "";	# $partOutput[0 .. $partCnt][0 .. $partOutCnt[$_]]
# Destination port number
# This shows which destination parts' port is connected to each output
$partOutputPort[0][0] = 0;	# $partOutputPort[0 .. $partCnt][0 .. $partOutCnt[$_]]

# Output port source number
# For each part, for each output port it keeps the output port source number
$partOutputPortUsed[0][0] = 0;	# $partOutputPortUsed[0 .. $partCnt][0 .. $partOutCnt[$_]]

# Part names annotated with subsystem names
$xpartName[0] = "";	# $xpartName[0 .. $partCnt]

# Part names not annotated with subsystem names
$partName[0] = "";	# $partName[0 .. $partCnt]

# Part type
$partType[0] = "";	# $partType[0 .. $partCnt]

# Name of subsystem where part belongs
$partSubName[0] = "";	# $partSubName[0 .. $partCnt]

# For each part its subsystem number
$partSubNum[0] = 0;	# $partSubNum[0 .. $partCnt]
$subSys = 0;	# Subsystems counter
$subSysName[0] = "";	# Subsystem names

# Subsystem part number ranges
$subSysPartStart[0] = 0;
$subSysPartStop[0] = 0;

# IPC output code
$ipcOutputCode = "";

# Set if doing direct DAC writed (no DMA)
$directDacWrite = 0;

# Set to disable zero padding DAC data
$noZeroPad = 0;

# Special case for LHO PEM MID to add 1sec on startup
$lhomid = 0;

# Set if DAC writes with no FIFO preload
$optimizeIO = 0;

# number of extra cycles to add to the DAC fifo for General standard DACS,
# or to add to write-ahead for LIGO DACS.
# these are added to, and do not replace the calculated delay used by default.
# this calculated delay is set to avoid data starvation and is different for
# different models of DAC and different settings of clock_div
$extra_dac_delay_cycles = 0;

# channel number to use for DAC duotone on the first DAC
# if negative, then count from the end, so the last
# channel can be indicated by -1
$dac_dt_chan = -1;

# Clear the part input and output counters
# This implies a maximum part count of 2000 per model.
for ($ii = 0; $ii < 2000; $ii++) {
  $partInCnt[$ii] = 0;
  $partOutCnt[$ii] = 0;
  $partInUsed[$ii] = 0;
}
}

#// \b sub \b printVariables \n
#// Add top level variable declarations to generated C Code for selected CDS parts. \n\n
sub printVariables {
for($ii=0;$ii<$partCnt;$ii++)
{
       #print "DBG: cdsPart = $cdsPart[$ii]   partType = $partType[$ii]\n";          # DBG
	if ($cdsPart[$ii]) {
           if ($partType[$ii] ne "FunctionCall") {
              if ($partType[$ii] =~ /^TrueRMS/) {
#                print "\n+++  TEST:  Found a TrueRMS\n";
#                print "\n+++  DESCR=$blockDescr[$ii]\n";

                 if ($blockDescr[$ii] =~ /^window_size=(\d+)/) {
#                   print "\n+++  VALUE=$1\n";
                    $windowSize = $1;
                 }
		 else {
                    $windowSize = 1024;
		 }
	      }
              ("CDS::" . $partType[$ii] . "::printFrontEndVars") -> ($ii);
           }
	}

	if($partType[$ii] eq "DELAY") {
		print OUT "static double \L$xpartName[$ii] = 0.0;\n";
	}
	if($partType[$ii] eq "GROUND")  {
            if ($groundDecl == 0)  {                                       # =+=  MA  =+=
                print OUT "static double ground;\n";                       # =+=  MA  =+=
                $groundDecl++;                                             # =+=  MA  =+=
            }                                                              # =+=  MA  =+=
	}
	if($partType[$ii] eq "CONSTANT")  {
		print OUT "static double \L$xpartName[$ii];\n";
	}
}
print OUT "\n\n";
}

#// \b sub \b commify_series \n
#// Create comma separated string from the lements of an array \n\n
sub commify_series {
    my $sepchar = grep(/,/ => @_) ? ";" : ",";
    (@_ == 0) ? ''                                      :
    (@_ == 1) ?  $_[0]                                   :
                join("$sepchar", @_[0 .. $#_]);
}
#// \b sub \b top_name_transform \n
#// Transform record name for exculsion of sys/subsystem parts \n
#// This function replaces first underscode with the hyphen \n\n
sub top_name_transform {
   ($name) =  @_;
   $name =~ s/_/-/;
   return $name;
};

#// \b sub \b system_name_part \n
#//  Get the system name (the part before the hyphen) \n\n
sub system_name_part {
   ($name) =  @_;
   $name =~ s/([^_]+)-\w+/$1/;
   return $name;
}

