package CDS::Dacligo28;
use Exporter;
@ISA = ('Exporter');

require "lib/medmGen.pm";

require "lib/Dac_common.pm";

$max_chan_index = $Dac_common::board_num_chans{LIGO_28AO32} - 1; #One less than the number of channels

#//     \page Dacligo28 Dacligo28.pm
#//     Dacligo28.pm - provides RCG support for LIGO 28 bit, 32 channel DAC modules.
#//
#// \n
#// \n


#// \n \n
#// \b sub \b initDac \n 
#// Called by Parser3.pm to check if ADC supported and fill in ADC info. \n
#// See Parser3.pm function sortDacs(), where the information in global arrays is sorted \n
#// if there is a new global array introduced, it will need to be addressed in sortDacs() \n\n
#
sub initDac {
    my ($node) = @_;
    $::dacPartNum[$::dacCnt] = $::partCnt;
    for (0 .. $max_chan_index) {
        $::partInput[$::partCnt][$_] = "NC";
    }

    my $desc = ${$node->{FIELDS}}{"Description"};
    printf "DAC PART TYPE description `$desc'\n";
    my ($type) = $desc =~ m/type=([^,]+)/g;
    printf "DAC PART TYPE $type\n";
    my ($num) = $desc =~ m/card_num=([^,]+)/g;
    if ($type eq undef) {
        $type = $Dac_common::default_board_type;
    }
    if ($num eq undef || $num < 0 || $num > $Dac_common::max_dac_modules) {
        die "DAC $::dacCnt; type=$type has an invalid card_num, ($num). All DACs must have a valid card num [0-$Dac_common::max_dac_modules] specified.
        See the wiki for more info: https://git.ligo.org/cds/software/advligorts/-/wikis/cdsDAC_N\n";
	}
    print "DAC $::dacCnt; type=$type; num=$num\n";
    
    # Check if this is a supported board type
    if ( ! defined $Dac_common::board_num_chans{$type}) {
        print "Unsupported board type\n";
        print "Known board types:\n";
        foreach (keys %Dac_common::board_num_chans) {
            print "\t$_\n";
        }
        exit 1;
    }

    $::dacType[$::dacCnt] = $type;
    $::dacNum[$::dacCnt] = $num;
    $::card2array[$::partCnt] = $::dacCnt;
    print "LIGODACINIT type = $::dacType[$::dacCnt] num = $::dacNum[$::dacCnt] card2arry = $::card2array[$::partCnt] daccnt = $::dacCnt \n";
    $::dacCnt++;
}


#// \b sub \b partType \n 
#// Required subroutine for RCG \n
#// Returns Dac20 \n\n
sub partType {
    return Dacligo28;
}

#// \b sub \b printHeaderStruct \n 
#// Required subroutine for RCG \n
#// Print Epics communication structure into a header file \n
#// Current part number is passed as first argument \n
#// For DAC part, nothing required to be placed in the Epics comms struct. \n\n
sub printHeaderStruct {
        my ($i) = @_;
}

#// \b sub \b printEpics \n 
#// Required subroutine for RCG \n
#// Print Epics variable definitions \n
#// Current part number is passed as first argument \n
#// For DAC part, there are no EPICS records generated. \n\n
sub printEpics {
    my ($i) = @_;
}



#// \b sub \b printFrontEndVars \n 
#// Required subroutine for RCG \n
#// Print variable declarations int front-end file \n
#// Current part number is passed as first argument \n\n
sub printFrontEndVars  {
    my ($i) = @_;
}

# Check inputs are connected
sub checkInputConnect {
    my ($i) = @_;
    return "";
}

#// \b sub \b frontEndInitCode \n 
#// Required subroutine for RCG \n
#// Return front end initialization code \n
#// Argument 1 is the part number \n
#// Returns calculated code string \n \n
sub frontEndInitCode {
    my ($i) = @_;
    my $dacNum = $::card2array[$i];
        my $calcExp = "// DAC number is $dacNum\n";
        for (0 .. $max_chan_index) {
          my $fromType = $::partInputType[$i][$_];
          if (($fromType ne "GROUND") && ($::partInput[$i][$_] ne "NC")) {
                $calcExp .= "dacOutUsed\[";
                $calcExp .= $dacNum;
                $calcExp .= "\]\[";
                $calcExp .= $_;
                $calcExp .= "\] =  1;\n";
          }
        }
    return $calcExp;
        return "";
}

#// \b sub \b fromExp \n 
#// Required subroutine for RCG \n
#// Figure out part input code \n
#// Argument 1 is the part number \n
#// Argument 2 is the input number \n
#// Returns calculated input code \n\n
sub fromExp {
    my ($i, $j) = @_;
    return "";
}


#// \b sub \b frontEndCode \n 
#// Required subroutine for RCG \n
#// Return front end code \n
#// Argument 1 is the part number \n
#// Returns calculated code string \n\n
sub frontEndCode {
    my ($i) = @_;
    my $dacNum = $::card2array[$i];
        my $calcExp = "// DAC number is $dacNum\n";
        for (0 .. $max_chan_index) {
          my $fromType = $::partInputType[$i][$_];
          if (($fromType ne "GROUND") && ($::partInput[$i][$_] ne "NC")) {
                $calcExp .= "dacOut\[";
                $calcExp .= $dacNum;
                $calcExp .= "\]\[";
                # $calcExp .= $::partOutputPort[$i][$_];
                $calcExp .= $_;
                $calcExp .= "\] = ";
                $calcExp .= $::fromExp[$_];
                $calcExp .= ";\n";
          }
        }
    return $calcExp;
}


#// \b sub \b createDac20Medm \n 
#// Called by feCodeGen.pl to auto gen DAC20 channel MEDM screens \n
#// This code requires /lib/medmGen.pm \n\n
sub createMedm
{

    my ($medmDir,$mdlName,$ifo,$dcuid,$medmTarget,$dacNum) = @_;
 # Define colors to be sent to screen gen.
    my %ecolors = ( "white" => "0",
            "black" => "14",
            "red" => "20",
            "green" => "60",
            "blue" => "54",
            "brown" => "34",
            "gray" => "2",
            "ltblue" => "50",
            "mdblue" => "42",
            "dacblue" => "44",
            "yellow" => "55"
        );

    my $ii=0;

    my $right_shift = 250;

    my $fname = "$mdlName\_DAC_MONITOR_$dacNum.adl";
    # Create MEDM File
    print "creating file $medmDir\/$fname \n";
    open(OUTMEDM, ">$medmDir/$fname") || die "cannot open $medmDir/$fname for writing ";

    my $xpos = 0; my $ypos = 0; my $width = 527; my $height = 570;
    $medmdata = ("CDS::medmGen::medmGenFile") -> ($medmDir,$fname,$width,$height);

    # ************* Create Banner ******************************************************************************
    # Put blue rectangle banner at top of screen
    $height = 22;
    $medmdata .= ("CDS::medmGen::medmGenRectangle") -> ($xpos,$ypos,$width,$height,$ecolors{blue},"","","");
    # Add Display Name
    $xpos = 55; $ypos = 4; $width = 120; $height = 15;        
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"$mdlName\_DAC_MONITOR_$::dacCardNum[$dacNum]",$ecolors{white});

    # ************* Create Background **************************************************************************
    # Add Background rectangles
    $xpos = 14; $ypos = 27; $width = 500; $height = 150;
    $medmdata .= ("CDS::medmGen::medmGenRectangle") -> ($xpos,$ypos,$width,$height,$ecolors{gray},"","","");
    $xpos = 14; $ypos = 198; $width = 500; $height = 360;
    $medmdata .= ("CDS::medmGen::medmGenRectangle") -> ($xpos,$ypos,$width,$height,$ecolors{gray},"","","");
    $xpos = 14; $ypos = 27; $width = 500; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenRectangle") -> ($xpos,$ypos,$width,$height,$ecolors{black},"","","");
    $xpos = 14; $ypos = 180; $width = 500; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenRectangle") -> ($xpos,$ypos,$width,$height,$ecolors{black},"","","");

    # ************* Add Text  **********************************************************************************
    # Add DAC top label
    $xpos = 48; $ypos = 27; $width = 140; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"DAC $::dacCardNum[$dacNum] - LIGO 28 Bit",$ecolors{white});
    # Add DAC OUT label
    $xpos = 70; $ypos = 221; $width = 45; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"OUTPUT",$ecolors{black});
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos+$right_shift,$ypos,$width,$height,"OUTPUT",$ecolors{black});
    # Add OFC OUT label
    $xpos = 175; $ypos = 203; $width = 45; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"OVERFLOW",$ecolors{black});
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos+$right_shift,$ypos,$width,$height,"OVERFLOW",$ecolors{black});
    $xpos = 149; $ypos = 221; $width = 45; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"PER SEC",$ecolors{black});
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos+$right_shift,$ypos,$width,$height,"PER SEC",$ecolors{black});
    $xpos = 201; $ypos = 221; $width = 45; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"ACCUM",$ecolors{black});
    $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos+$right_shift,$ypos,$width,$height,"ACCUM",$ecolors{black});

    # Add DAC Channel labels
    $xpos = 15; $ypos = 240; $width = 35; $height = 15;
    for($ii=0; $ii<$Dac_common::board_num_chans{LIGO_28AO32}/2; $ii+=1)
    {
        #Draw left column 
        $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos,$ypos,$width,$height,"CH $ii",$ecolors{black});
        #Draw right column
        my $r_indx = $ii + $Dac_common::board_num_chans{LIGO_28AO32}/2;
        $medmdata .= ("CDS::medmGen::medmGenText") -> ($xpos + $right_shift,$ypos,$width,$height,"CH $r_indx",$ecolors{black});
        $ypos += 20;
    }

    # Add DAC Data Monitors
    $xpos = 50; $ypos = 238; $width = 90; $height = 15;
    for($ii=0;$ii<$Dac_common::board_num_chans{LIGO_28AO32}/2;$ii++)
    {
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OUTPUT_$dacNum\_$ii",$ecolors{white},$ecolors{blue},"static");
        my $r_indx = $ii + $Dac_common::board_num_chans{LIGO_28AO32}/2;
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos+$right_shift,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OUTPUT_$dacNum\_$r_indx",$ecolors{white},$ecolors{blue},"static");
        $ypos += 20;
    }
    $xpos = 150; $ypos = 238; $width = 45; $height = 15;
    for($ii=0;$ii<$Dac_common::board_num_chans{LIGO_28AO32}/2;$ii++)
    {
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OVERFLOW_$dacNum\_$ii",$ecolors{white},$ecolors{blue},"static");
        my $r_indx = $ii + $Dac_common::board_num_chans{LIGO_28AO32}/2;
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos+$right_shift,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OVERFLOW_$dacNum\_$r_indx",$ecolors{white},$ecolors{blue},"static");
        $ypos += 20;
    }
    $xpos = 200; $ypos = 238; $width = 55; $height = 15;
    for($ii=0;$ii<$Dac_common::board_num_chans{LIGO_28AO32}/2;$ii++)
    {
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OVERFLOW_ACC_$dacNum\_$ii",$ecolors{white},$ecolors{blue},"static");
        my $r_indx = $ii + $Dac_common::board_num_chans{LIGO_28AO32}/2;
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos+$right_shift,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_OVERFLOW_ACC_$dacNum\_$r_indx",$ecolors{white},$ecolors{blue},"static");
        $ypos += 20;
    }

    # ************* Add Data Monitors  ***************************************************************************
    # Add On Line Status Monitor
    $xpos = 26; $ypos = 52; $width = 12; $height = 12;
    $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","0","0",$ecolors{green},$ecolors{red});
    # Add Watchdog Status Monitor
    $xpos = 26; $ypos = 67; $width = 12; $height = 12;
    $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","1","1",$ecolors{green},$ecolors{red});
    # Add Overrange Status Monitor
    $xpos = 26; $ypos = 82; $width = 12; $height = 12;
    $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","2","2",$ecolors{green},$ecolors{red});
    if($::iopModel == 1) {
        # Add AI Chassis WD Status Monitor
        $xpos = 26; $ypos = 97; $width = 12; $height = 12;
        $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","4","4",$ecolors{green},$ecolors{red});
        # Add FIFO Status Monitor
        $xpos = 26; $ypos = 112; $width = 12; $height = 12;
        $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","3","3",$ecolors{green},$ecolors{red});
    }
    # Add ON LINE Label
    $xpos = 51; $ypos = 52; $width = 100; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"ON LINE",$ecolors{black});

    if($::iopModel == 1) {
        # Add TEMP Label and value box, if this is an IOP model
        $xpos = 150; $ypos = 52; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"Temp (C):",$ecolors{black});
        $xpos = 205; $ypos = 52; $width = 50; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextMon") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_$dacNum\_TEMP_DEG_C",$ecolors{white},$ecolors{black},"alarm");
    }

    # Add WATCHDOG Label
    $xpos = 51; $ypos = 67; $width = 100; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"WATCHDOG",$ecolors{black});
    # Add OVERRANGE Label
    $xpos = 51; $ypos = 82; $width = 100; $height = 15;
    $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"OVERRANGE",$ecolors{black});
    if($::iopModel == 1) {
        # Add AI CHASSIS WD Label
        $xpos = 51; $ypos = 97; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"AI CHASSIS WD",$ecolors{black});
        # Add FIFO STATUS Label
        $xpos = 51; $ypos = 112; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"FIFO STATUS",$ecolors{black});
        # Add FIFO EMPTY Label
        $xpos = 81; $ypos = 132; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"EMPTY",$ecolors{black});
        # Add FIFO HI QTR Label
        $xpos = 81; $ypos = 147; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"HIGH QUARTER",$ecolors{black});
        # Add FIFO FULL Label
        $xpos = 81; $ypos = 162; $width = 100; $height = 15;
        $medmdata .= ("CDS::medmGen::medmGenTextLeft") -> ($xpos,$ypos,$width,$height,"FULL",$ecolors{black});
        # Add FIFO EMPTY Monitor
        $xpos = 58; $ypos = 132; $width = 12; $height = 12;
        $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","5","5",$ecolors{red},$ecolors{green});
        # Add FIFO HI QTR Monitor
        $xpos = 58; $ypos = 147; $width = 12; $height = 12;
        $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","6","6",$ecolors{red},$ecolors{green});
        # Add FIFO FULL Monitor
        $xpos = 58; $ypos = 162; $width = 12; $height = 12;
        $medmdata .= ("CDS::medmGen::medmGenByte") -> ($xpos,$ypos,$width,$height,"$ifo\:FEC-$dcuid\_DAC_STAT_$dacNum","7","7",$ecolors{red},$ecolors{green});

    }

    print OUTMEDM "$medmdata \n";
    close OUTMEDM;

}
