program %SEQUENCER_NAME%

#define SEQUENCER_NAME_%SEQUENCER_NAME%

%% #include <stdio.h>
%% #include <stdlib.h>
%% #include <string.h>
%% #include <math.h>
%% // We included math.h, so make sure
%% // not to use LIGO inline math functions
%% #define USE_STDLIB_MATH
%% #include <unistd.h>
%% #include <pthread.h>
%% #include <fpvalidate.h>
%% #include <daqmap.h>
%% #include <load_daq.h>
%% #include <errno.h>
%% #include <epicsTime.h>
%% #include <cadef.h>
%% #include <alarm.h>                                                    /* MA */
%% #include <sys/types.h>                                                /* MA */
%% #include <sys/stat.h>                                                 /* MA */
%% #include <ctype.h>

#if defined(RFM_EPICS)
%% #define SERVO16K
#else
%% #define SERVO5HZ
#endif

%% #define MAX_MODULES %FMNUM%
#define MAX_MODULES %FMNUM%
#define MAX_MODULES_TIMES_TWO %FMNUMx2%
#define MAX_MODULES_TIMES_TEN %FMNUMx10%

%%#define FILTER_FILE_READ_ERR    0x1 
%%#define FILTER_TRANSMISSION_ERR 0x2
%%#define FILTER_FE_TIMOUT_ERR    0x4
%%#define FILTER_COPY_ERR         0x8 //Set when the copy from */chans/<FILTER_FILE>.txt */chans/tmp/<FILTER_FILE>.txt fails

%% #include "fm10Gen.h"
%% #define FM_SUBSYS_NUM  1
%% #include "fmReadCoeff.h"
%% #include "feComms.h"
%% #include "../../cds-shmem/cds-shmem.h"
%% #include "fe_state_word.h"
%% #include "sdf_file_loaded.h"

/* Cat string and make upper case */                                     /* MA */
%% static char *strcat_upper(char *dest, char *src) {                    /* MA */
%%   char *d = dest;                                                     /* MA */
%%   for( ; *d; d++);                                                    /* MA */
%%   for( ; (*d++ = toupper(*src)); src++);                              /* MA */
%%   return dest;                                                        /* MA */
%% }                                                                     /* MA */
                                                                         /* MA */
/* Cat string and make lower case */                                     /* MA */
%% static char *strcat_lower(char *dest, char *src) {                    /* MA */
%%   char *d = dest;                                                     /* MA */
%%   for( ; *d; d++);                                                    /* MA */
%%   for( ; (*d++ = tolower(*src)); src++);                              /* MA */
%%   return dest;                                                        /* MA */
%% }                                                                     /* MA */

#if defined(RFM_EPICS)
%% #define rfm_assign(a,b) if ((a) != (b)) { a = (b); }
#else
%% #define rfm_assign(a,b) ((a)=(b))
#endif

#if defined(SEQUENCER_NAME_tcsh1) || defined(SEQUENCER_NAME_tcsh2)
%% #include "tcs.h"
#endif

%DECL1%

#if defined(RFM_EPICS)
%% static shmem_handle g_rfm_shm_handle = NULL; 
%% static volatile RFM_FE_COMMS *pRfm;
%% static volatile VME_COEF *pVmeCoeff;
%% static volatile FILT_MOD *pFilt;
%% static %EPICS_TYPE% *pEpics;
%% static unsigned int sysnum;
%% extern int fmCreatePartial(char *, char *, char *);;
#else
%% static VME_COEF vmeCoeffSpace;
%% static COEF coeffSpace;
%% static FILT_MOD filtSpace;
%% static VME_COEF *pVmeCoeff = &vmeCoeffSpace;
%% static FILT_MOD *pFilt = &filtSpace;
%% static %EPICS_TYPE% pEpicsSpace;
%% static %EPICS_TYPE% *pEpics = &pEpicsSpace;
#endif

%% static int g_filterError = 0;


%% // set to 1 when safe.snap (or any sdf file) is finished loading
%% // triggers setting BURT_RESTORE=1
%% int sdf_file_loaded = 0;
%% // remember previous value so we only trigger once on transition
%% int sdf_file_loaded_old = 0;

%% char *build_date = __DATE__ " " __TIME__;

string build_time;
assign build_time to "{ifo}:FEC-{sysnum}_BUILD_DATE";

string msg;
assign msg to "{ifo}:FEC-{sysnum}_MSG";

string msg2;
assign msg2 to "{ifo}:FEC-{sysnum}_MSG2";

string msgDAQ;
assign msgDAQ to "{ifo}:FEC-{sysnum}_MSGDAQ";

string msgFESTAT;
assign msgFESTAT to "{ifo}:FEC-{sysnum}_MSG_FESTAT";

int stateWord;
assign stateWord to "{ifo}:FEC-{sysnum}_STATE_WORD";

double epicsSyncTime;
assign epicsSyncTime to "{ifo}:FEC-{sysnum}_EPICS_SYNC_TIME";

int epicsWait;
assign epicsWait to "{ifo}:FEC-{sysnum}_EPICS_WAIT";

int allNewCoeff;
assign allNewCoeff to "{ifo}:FEC-{sysnum}_LOAD_NEW_COEFF";

string localtimestring;
assign localtimestring to "{ifo}:FEC-{sysnum}_TIME_STRING";

int uptime_day;
assign uptime_day to "{ifo}:FEC-{sysnum}_UPTIME_DAY";

int uptime_hour;
assign uptime_hour to "{ifo}:FEC-{sysnum}_UPTIME_HOUR";

int uptime_minute;
assign uptime_minute to "{ifo}:FEC-{sysnum}_UPTIME_MINUTE";

string gdsmon_str[32];
assign gdsmon_str[0] to "{ifo}:FEC-{sysnum}_GDS_STR_0";
assign gdsmon_str[1] to "{ifo}:FEC-{sysnum}_GDS_STR_1";
assign gdsmon_str[2] to "{ifo}:FEC-{sysnum}_GDS_STR_2";
assign gdsmon_str[3] to "{ifo}:FEC-{sysnum}_GDS_STR_3";
assign gdsmon_str[4] to "{ifo}:FEC-{sysnum}_GDS_STR_4";
assign gdsmon_str[5] to "{ifo}:FEC-{sysnum}_GDS_STR_5";
assign gdsmon_str[6] to "{ifo}:FEC-{sysnum}_GDS_STR_6";
assign gdsmon_str[7] to "{ifo}:FEC-{sysnum}_GDS_STR_7";
assign gdsmon_str[8] to "{ifo}:FEC-{sysnum}_GDS_STR_8";
assign gdsmon_str[9] to "{ifo}:FEC-{sysnum}_GDS_STR_9";
assign gdsmon_str[10] to "{ifo}:FEC-{sysnum}_GDS_STR_10";
assign gdsmon_str[11] to "{ifo}:FEC-{sysnum}_GDS_STR_11";
assign gdsmon_str[12] to "{ifo}:FEC-{sysnum}_GDS_STR_12";
assign gdsmon_str[13] to "{ifo}:FEC-{sysnum}_GDS_STR_13";
assign gdsmon_str[14] to "{ifo}:FEC-{sysnum}_GDS_STR_14";
assign gdsmon_str[15] to "{ifo}:FEC-{sysnum}_GDS_STR_15";
assign gdsmon_str[16] to "{ifo}:FEC-{sysnum}_GDS_STR_16";
assign gdsmon_str[17] to "{ifo}:FEC-{sysnum}_GDS_STR_17";
assign gdsmon_str[18] to "{ifo}:FEC-{sysnum}_GDS_STR_18";
assign gdsmon_str[19] to "{ifo}:FEC-{sysnum}_GDS_STR_19";
assign gdsmon_str[20] to "{ifo}:FEC-{sysnum}_GDS_STR_20";
assign gdsmon_str[21] to "{ifo}:FEC-{sysnum}_GDS_STR_21";
assign gdsmon_str[22] to "{ifo}:FEC-{sysnum}_GDS_STR_22";
assign gdsmon_str[23] to "{ifo}:FEC-{sysnum}_GDS_STR_23";
assign gdsmon_str[24] to "{ifo}:FEC-{sysnum}_GDS_STR_24";
assign gdsmon_str[25] to "{ifo}:FEC-{sysnum}_GDS_STR_25";
assign gdsmon_str[26] to "{ifo}:FEC-{sysnum}_GDS_STR_26";
assign gdsmon_str[27] to "{ifo}:FEC-{sysnum}_GDS_STR_27";
assign gdsmon_str[28] to "{ifo}:FEC-{sysnum}_GDS_STR_28";
assign gdsmon_str[29] to "{ifo}:FEC-{sysnum}_GDS_STR_29";
assign gdsmon_str[30] to "{ifo}:FEC-{sysnum}_GDS_STR_30";
assign gdsmon_str[31] to "{ifo}:FEC-{sysnum}_GDS_STR_31";

#ifndef NO_DAQ_IN_SKELETON

int reload;
assign reload to "{ifo}:DAQ-FEC_{sysnum}_LOAD_CONFIG";

int dcmsg;
assign dcmsg to "{ifo}:DAQ-FEC_{sysnum}_MSG";

int chnCnt;
assign chnCnt to "{ifo}:DAQ-FEC_{sysnum}_CHAN_CNT";

int epicschnCnt;
assign epicschnCnt to "{ifo}:DAQ-FEC_{sysnum}_EPICS_CHAN_CNT";

int dataSize;
assign dataSize to "{ifo}:DAQ-FEC_{sysnum}_TOTAL";

int dcuId;
assign dcuId to "{ifo}:DAQ-FEC_{sysnum}_DCU_ID";

#endif


unsigned int prev_gps = 0;
unsigned int prev_cycle = 0;
%% /* ezCaWrites we want to update slower */
unsigned int pvUpdateCycle = 0;
int prev_seqTrig = 0;


%DECL2%

%% static fmReadCoeff fmc = {
%%  "lho", "h1", "xxx", 0, {{"", "", MAX_MODULES, fmmap0, 0}},
%% };
%% char system_lower[ 128 ];
%% char *s_hold;


%% static const double conv = 0.000152588;
%% static const int mask[2] = {0xAAA0,0x30AA};
%% extern pthread_mutex_t seq_lock;

#if defined(SEQUENCER_NAME_hepi) || defined(SEQUENCER_NAME_hepia)
%% static unsigned int cpunum;
#endif

#ifdef SEQUENCER_NAME_asc
#define FILT_QUAD_SIZE 10
int filt[FILT_QUAD_SIZE];
assign filt to
{"{ifo}:{sys}-WFS1_I_QUAD","{ifo}:{sys}-WFS1_Q_QUAD","{ifo}:{sys}-WFS2_I_QUAD",
 "{ifo}:{sys}-WFS2_Q_QUAD","{ifo}:{sys}-WFS3_I_QUAD","{ifo}:{sys}-WFS3_Q_QUAD",
 "{ifo}:{sys}-WFS4_I_QUAD","{ifo}:{sys}-WFS4_Q_QUAD","{ifo}:{sys}-WFS5_I_QUAD",
 "{ifo}:{sys}-WFS5_Q_QUAD"};
#endif

#ifdef SEQUENCER_NAME_asc40m
#define FILT_QUAD_SIZE 12
int filt[FILT_QUAD_SIZE];
assign filt to
{"{ifo}:{sys}-WFS1_I_QUAD","{ifo}:{sys}-WFS1_Q_QUAD","{ifo}:{sys}-WFS2_I_QUAD",
 "{ifo}:{sys}-WFS2_Q_QUAD","{ifo}:{sys}-WFS3_I_QUAD","{ifo}:{sys}-WFS3_Q_QUAD",
 "{ifo}:{sys}-WFS4_I_QUAD","{ifo}:{sys}-WFS4_Q_QUAD","{ifo}:{sys}-WFS5_I_QUAD",
 "{ifo}:{sys}-WFS5_Q_QUAD","{ifo}:{sys}-WFS6_I_QUAD","{ifo}:{sys}-WFS6_Q_QUAD"};
#endif

#ifdef SEQUENCER_NAME_ascmc
#define FILT_QUAD_SIZE 4
int filt[FILT_QUAD_SIZE];
assign filt to
{"{ifo}:{sys}-WFS1_I_QUAD","{ifo}:{sys}-WFS1_Q_QUAD","{ifo}:{sys}-WFS2_I_QUAD",
 "{ifo}:{sys}-WFS2_Q_QUAD"};
#endif

#ifdef SEQUENCER_NAME_lsc_removed
int lscModeSwitch;
assign lscModeSwitch to "{ifo}:LSC-FE_MODE";

int laState;
assign laState to "{ifo}:LSC-LA_State_Bits_Read";

%% static int lastLscModeSwitch;

%% static int coeffReset = 0;

#endif

#if defined(SEQUENCER_NAME_tcsh1) || defined(SEQUENCER_NAME_tcsh2)

double tcs1Input;
assign tcs1Input to "{ifo}:ASC-WFS5_PIT_OUT16"; 
/*assign tcs1Input to "{ifo}:LSC-LA_SPOB_NORM";*/
double tcs2Input;
assign tcs2Input to "{ifo}:LSC-ASI_CORR_OUT16";
double  inpt;
double  outpts[4];

double tcsXOutput;
double tcsYOutput;


#if defined(SEQUENCER_NAME_tcsh2)
assign tcsXOutput to "{ifo}:TCS-ITMX_AOMDRV";
assign tcsYOutput to "{ifo}:TCS-ITMY_AOMDRV";
#else
assign tcsXOutput to "{ifo}:TCS-ITMX_PWRSET";
assign tcsYOutput to "{ifo}:TCS-ITMY_PWRSET";
#endif

int tcsEnable;
assign tcsEnable to "{ifo}:TCS-SERVO_EN";
#endif

#define copy_labels(ii)\
       strcpy(labels0[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[0]));\
       strcpy(labels1[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[1]));\
       strcpy(labels2[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[2]));\
       strcpy(labels3[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[3]));\
       strcpy(labels4[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[4]));\
       strcpy(labels5[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[5]));\
       strcpy(labels6[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[6]));\
       strcpy(labels7[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[7]));\
       strcpy(labels8[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[8]));\
       strcpy(labels9[ii],(const char *)(pVmeCoeff->vmeCoeffs[ii].filtName[9]));
#define pvput_labels(ii)\
       pvPut(labels0[ii]);\
       pvPut(labels1[ii]);\
       pvPut(labels2[ii]);\
       pvPut(labels3[ii]);\
       pvPut(labels4[ii]);\
       pvPut(labels5[ii]);\
       pvPut(labels6[ii]);\
       pvPut(labels7[ii]);\
       pvPut(labels8[ii]);\
       pvPut(labels9[ii]);


%% static DAQ_INFO_BLOCK *info;
%% static shmem_handle  g_base_shm_handle = NULL;
%% static volatile void *base;
%% static DAQ_INFO_BLOCK infoTmp;
%% static GDS_INFO_BLOCK gdsTmp;
%% static shmem_handle g_gdsInfo_shm_handle = NULL;
%% static GDS_INFO_BLOCK *gdsInfo;
%% static char site[160];
%% static char ifo[160];
%% static char daqsys[160];
%% static char gdssmname[64];
%% static int last_gds_tp[32];

%% char fName[4][256];                                                   /* MA */
%% char fType[3][10] = {"IIR", "FIR", "IIR & FIR"};                      /* MA */
%% char fNameDAQ[256];                                                   /* ma */
%% char cpCmd[256];                                                   /* ma */
%% char diffCmd[256];                                                   /* ma */
%% char cfdir[256];
%% char cfmodel[256] = "";

#ifdef FIR_FILTERS                                                       /* MA */
%% int fltrTypes = 2;                                                    /* MA */
#else                                                                    /* MA */
%% int fltrTypes = 1;                                                    /* MA */
#endif                                                                   /* MA */

/* %% struct filterThresh thresholds[MAX_MODULES];                          MA */


int g_daq_loaded = 0;

%% static void copy_info() {
%%   int i;
%%   for (i = 0; i < infoTmp.numChans; i++) {
%%     strcpy(info -> tp [i].channel_name, infoTmp.tp [i].channel_name);
%%	printf("copyinfo %d = %s\n",i,info -> tp [i].channel_name);
%%     info -> tp [i].tpnum = infoTmp.tp [i].tpnum;
%%     info -> tp [i].dataType = infoTmp.tp [i].dataType;
%%     info -> tp [i].dataRate = infoTmp.tp [i].dataRate;
%%     info -> tp [i].dataGain = infoTmp.tp [i].dataGain;
%%   }
%%   info -> configFileCRC = infoTmp.configFileCRC;
%%   info->numChans = infoTmp.numChans;
%%   info->numEpicsInts = infoTmp.numEpicsInts;
%%   info->numEpicsFloats = infoTmp.numEpicsFloats;
%%   info->numEpicsFilts = infoTmp.numEpicsFilts;
%%   info->numEpicsTotal = infoTmp.numEpicsTotal;
%%   info->cpyepics2times = infoTmp.cpyepics2times;
%%   info->cpy2IntOffset = infoTmp.cpy2IntOffset;
%%   info->cpyIntSize[0] = infoTmp.cpyIntSize[0];
%%   info->cpyIntSize[1] = infoTmp.cpyIntSize[1];
%%   info->epicsdblDataOffset = infoTmp.epicsdblDataOffset;
%% }

%% static void copy_gds_info() {
%%   int i;
%%   for (i = 0; i < 32; i++) {
%%      last_gds_tp[i] = -1;
%%   }
%%   for (i = 0; i < gdsTmp.totalchans; i++) {
%% 	strcpy(gdsInfo->tpinfo[i].tpname,gdsTmp.tpinfo[i].tpname);;
%%	gdsInfo->tpinfo[i].tpnumber = gdsTmp.tpinfo[i].tpnumber;
%%      if(i<10) printf("GDS Name = %si Num = %d\n",gdsInfo->tpinfo[i].tpname,gdsInfo->tpinfo[i].tpnumber);
%%   }
%%   gdsInfo->totalchans = gdsTmp.totalchans;
%% }

%% static void detach_shmem() {
#ifndef NO_DAQ_IN_SKELETON
%%   shmem_close(g_base_shm_handle);
#endif
#if defined(RFM_EPICS)
%%   shmem_close(g_rfm_shm_handle);
%%   shmem_close(g_gdsInfo_shm_handle);
#endif 
%% }


ss monitorFilt{
 
state init
{
  when() {
%% {
%% int ii, jj;
%% int ij;
%% time_t lt = time(0);
%% strcpy(localtimestring, ctime(&lt));
%% localtimestring[strlen(localtimestring) - 1] = 0; /* Delete newline character */
   pvPut(localtimestring);
%% strcpy(build_time, build_date);
   pvPut(build_time);

#if defined(RFM_EPICS)
    sysnum = atoi(macValueGet("sysnum"));

#if defined(SEQUENCER_NAME_hepi) || defined(SEQUENCER_NAME_hepia)
    cpunum = 0;
%%  if(sysnum > 3) cpunum = 1;
%%  if(sysnum == 7) cpunum = 2;
%%  if(sysnum == 8) cpunum = 3;
    strncpy(fmc.system, macValueGet("sys"), sizeof(fmc.system)-1);
#endif

#endif

#if defined(SEQUENCER_NAME_tcsh1) || defined(SEQUENCER_NAME_tcsh2)
    tcsEnable = 0;
#endif

    strncpy(fmc.site, macValueGet("site"), sizeof(fmc.site)-1);
    strncpy(fmc.ifo, macValueGet("ifo"), sizeof(fmc.ifo)-1);
    strncpy(fmc.system, macValueGet("sysfile"), sizeof(fmc.system)-1);
    if (macValueGet("sysfxxx") != 0) {
      strncpy(fmc.subSys[0].name, macValueGet("sysfile"), sizeof(fmc.subSys[0].name)-1);
    } else {
      fmc.subSys[0].name[0] = 0;
    }
%%  {
%%    int l = strlen(fmc.system);
%%    if (l) {
%%	if (fmc.system[l-1] == '-' || fmc.system[l-1] == '_') {
%%	  fmc.system[l-1] = 0;
%%	}
%%    }
%%  }
%%  {
%%    int l = strlen(fmc.subSys[0].name);
%%    if (l) {
%%	if (fmc.subSys[0].name[l-1] == '-' || fmc.subSys[0].name[l-1] == '_') {
%%	  fmc.subSys[0].name[l-1] = 0;
%%	}
%%    }
%%  }

%% //Convert the system (model) name to a lower case version
%% strcpy(system_lower, fmc.system);
%% for(s_hold = system_lower; *s_hold; s_hold++) *s_hold=tolower(*s_hold);
%% strcpy(gdssmname, system_lower);
%% strcat(gdssmname, "_gds");


#if defined(RFM_EPICS)
%%  printf("Init Sequencer %s; system %d fmcsystem = %s\n", fmc.subSys[0].name, sysnum,fmc.system);
%%  g_rfm_shm_handle = shmem_open(system_lower, DEFAULT_SHMEM_ALLOC_SIZE_MB);
%%  pRfm = (RFM_FE_COMMS *) shmem_mapping(g_rfm_shm_handle);
%%  pFilt = (FILT_MOD *)(&pRfm->%EPICS_FILT_VAR%);
%%  pVmeCoeff = (VME_COEF*)(&pRfm->%EPICS_COEFF_VAR%);
%%  pEpics = (%EPICS_TYPE%*)(&pRfm->%EPICS_EPICS_VAR%);
%%  /* Zero the Epics structure out */
%%  memset(pEpics, 0, sizeof(%EPICS_TYPE%));
%%  printf("%s pFilt is at 0x%lx\n", fmc.subSys[0].name, ((unsigned long)pFilt-(unsigned long)pRfm));
%%  printf("%s pVmeCoeff is at 0x%lx\n", fmc.subSys[0].name, ((unsigned long)pVmeCoeff-(unsigned long)pRfm));
%%  printf("%s pVmeCoeff size is 0x%lx\n", fmc.subSys[0].name, sizeof(*pVmeCoeff));
%%  printf("%s pEpics is at 0x%lx\n", fmc.subSys[0].name, ((unsigned long)pEpics-(unsigned long)pRfm));
%%  printf("%s pEpics is at 0x%lx\n", fmc.subSys[0].name, ((unsigned long)pRfm));
%%  g_gdsInfo_shm_handle = shmem_open(gdssmname, DEFAULT_SHMEM_ALLOC_SIZE_MB); 
%%  gdsInfo = (GDS_INFO_BLOCK *) shmem_mapping(g_gdsInfo_shm_handle);
%%  printf("%s gdsinfo is at 0x%lx\n", gdssmname, (unsigned long)gdsInfo);
#endif

atexit(detach_shmem);

%% strcpy(fName[0], "/opt/rtcds/");                                        /* MA */
%% strcat_lower(fName[0], fmc.site);                                     /* MA */
%% strcat(fName[0], "/");                                          /* MA */
%% strcat_lower(fName[0], fmc.ifo);                                     /* MA */
%% strcat(fName[0], "/chans/");                                          /* MA */
%% strcpy (cfdir,fName[0]);;
%% strcpy(fName[2],fName[0]);
%% strcat(fName[2], "tmp/");                                          /* MA */
%% strcat_upper(fName[2], fmc.system);                                   /* MA */
%% strcat_upper(fName[0], fmc.system);                                   /* MA */
%% strcpy(fName[3],fName[2]);
%% strcat_upper(cfmodel, fmc.system);                                   /* MA */
%% if (strlen(fmc.subSys[0].name) > 0) {                                 /* MA */
%%    strcat(fName[0], "_");                                             /* MA */
%%    strcat_upper(fName[0], fmc.subSys[0].name);                        /* MA */
%% }                                                                     /* MA */
%% strcat(fName[0], ".");                                                /* MA */
%% strcpy(fName[1], fName[0]);                                           /* MA */
%% strcat(fName[0], "txt");                                              /* MA */
%% strcat(fName[2], ".txt");                                              /* MA */
%% strcat(fName[1], "fir");                                              /* MA */
%% strcat(fName[3], ".diff");                                              /* MA */

%% sprintf(cpCmd,"%s %s %s","cp",fName[0],fName[2]);
%% printf("copy file with command = %s\n",cpCmd);
%% sprintf(diffCmd,"%s %s %s %s %s","diff",fName[0],fName[2]," > ",fName[3]);

%DECL3%

%% int status = system(cpCmd);
%% if ( status != 0 ) {
%%     fprintf(stderr, "Could not copy filter file %s into working directory %s \n Check Permissions...", fName[0], fName[2]); 
%%     exit(1);
%% }
%% printf("copy file with status = %d\n",status);
%% status = system(diffCmd);
%%  fmc.pVmeCoeff = (VME_COEF *)pVmeCoeff; /* Initialize pointer for fmReadCoeffFile() */
#if MAX_MODULES > 0
%%  for(ii=0;ii<MAX_MODULES;ii++)
%%    for(jj=0;jj<FILTERS;jj++) {
%%        pVmeCoeff->vmeCoeffs[ii].filtSections[jj] = 0;
%%        pVmeCoeff->vmeCoeffs[ii].filterType[jj] = 0;
%%        strcpy((char *)(pVmeCoeff->vmeCoeffs[ii].filtName[jj]),"NA");
%%    }
#endif

%%  /* printf("About to read file \n"); */
    strcpy(msg, "Reading coeff file...");
    pvPut(msg);

%%  if (fmReadCoeffFile(&fmc, 0, pEpics->epicsOutput.timeDiag, 0) != 0) {
%%      g_filterError |= FILTER_FILE_READ_ERR;
%%  	fprintf(stderr, "Error: %s\n", fmReadErrMsg());
	    strncpy(msg, fmReadShortErrMsg(), MAX_STRING_SIZE-1);
%%  } else {
%%      g_filterError &= ~FILTER_FILE_READ_ERR; //Clear error
	    strcpy(msg, localtimestring);
#if !defined(RFM_EPICS)
	    /* Initialize variables for use in a filter module code */
	    initVars(pFilt, pFilt,&coeffSpace, MAX_MODULES, pVmeCoeff);
#endif
%%  }
    pvPut(msg);

#if MAX_MODULES > 0
%%  for(ii=0;ii<MAX_MODULES;ii++) {
%%	    copy_labels(ii);
	    pvput_labels(ii);
%%  }
#endif
%%  printf("Should have put the values on the screen by now. ;)\n");
%%  printf("Setting initial screen variables to zero.\n");
#if MAX_MODULES > 0
%%  for(ii=0;ii<MAX_MODULES;ii++){
      input[ii] = 0.0;
      pvPut(input[ii]);
      excite[ii] = 0.0;
      pvPut(excite[ii]);
      offset[ii] = 0.0;
      pvPut(offset[ii]);
%%    pFilt->inputs[ii].offset = 0.0;

      outgain[ii] = DEFAULT_FILTER_OUTGAIN_VAL;
      pvPut(outgain[ii]);
%%    pFilt->inputs[ii].outgain = DEFAULT_FILTER_OUTGAIN_VAL;
      gain_ramp_time[ii] = 0.0;
      pvPut(gain_ramp_time[ii]);
%%    pFilt->inputs[ii].gain_ramp_time = 0.0;

      limit[ii] = 0;
      pvPut(limit[ii]);
      pFilt->inputs[ii].limiter = limit[ii];
      pFilt->inputs[ii].opSwitchE = 0;
      pFilt->inputs[ii].rset = FM_OP_IN_NO_ACTION;
      pFilt->inputs[ii].mask = 0;
      pFilt->inputs[ii].control = 0;

      sw1[ii] = OPSWITCH_SW1_DEFAULT_NEW_FILT_VALUE;
      sw2[ii] = OPSWITCH_SW2_DEFAULT_NEW_FILT_VALUE;
      switchR1[ii] = 0;
      switchR2[ii] = 0;
      saveSwitch1[ii] = 0;
      saveSwitch2[ii] = 0;
      swMask[ii] = 0;
      swReq[ii] = 0;
      swstat_alarm_level[ii] = 0x7fff;
      pvPut(sw1[ii]);
      pvPut(switchR1[ii]);
      pvPut(saveSwitch1[ii]);
      pvPut(sw2[ii]);
      pvPut(switchR2[ii]);
      pvPut(saveSwitch2[ii]);
      pvPut(swMask[ii]);
      pvPut(swReq[ii]);
      pvPut(swstat_alarm_level[ii]);
%%  }
#endif

    allNewCoeff = 0;
    pvPut(allNewCoeff);

%% }
#ifdef NO_DAQ_IN_SKELETON
  } state monScreen
#else
  } state daqInit
#endif
}

state monScreen{

  when(1){
%% int ii, jj;	
%% int ij;
%% int rtruns = 0;
%% int myTimeout;
%% int uptime;
%% int festat;

%%    rtruns = 1;
%%    stateWord = pEpics->epicsOutput.stateWord
%%	            | (prev_gps == pEpics->epicsOutput.timeDiag
%%	            && prev_cycle == pEpics->epicsOutput.cycle);
%%    if (g_filterError != 0)
%%    {  
%%        stateWord |= FE_ERROR_FLT;
%%    }
%%    prev_gps = pEpics->epicsOutput.timeDiag;
%%    prev_cycle = pEpics->epicsOutput.cycle;

      //Check filter file error message
      pvGet(msg2);
%%    if(strncmp(msg2, "Modified", 8) == 0) stateWord |= FE_ERROR_CFC;

      //Check DAQ ini file error message
      pvGet(msgDAQ);
%%    if(strncmp(msgDAQ, "Modified", 8) == 0) stateWord |= FE_ERROR_CFC;
%%    if(strncmp(msgDAQ, "Can't stat", 10) == 0) stateWord |= FE_ERROR_CFC;
%%    if(!g_daq_loaded) stateWord |= FE_ERROR_DAQ;
        pvPut(stateWord);
// If RT Code runs, sync up to it.
// else just wait 50msec.
%%    if(stateWord & 1) rtruns = 0;
%%    usleep(10000);
%%    if(rtruns)
%%    {
%%	    myTimeout = 0;
%% 	    do{
%%		    usleep(2000);
%%		    myTimeout ++;
%% 	    }while((pEpics->epicsOutput.epicsSync == prev_seqTrig) && (myTimeout < 250));
%%    } else {
%% 	    usleep(10000);
%%    }
%%    pvUpdateCycle++;
%%    prev_seqTrig = pEpics->epicsOutput.epicsSync;
      epicsSyncTime = prev_seqTrig * 0.0625  + pEpics->epicsOutput.timeDiag;
%%    if(prev_seqTrig == 0) epicsSyncTime += 1;
      epicsWait = myTimeout;
      pvPut(epicsWait);
%%    uptime = pEpics->epicsOutput.timeDiag - pEpics->epicsOutput.startgpstime;
      uptime_day = uptime / 86400;
      uptime -= uptime_day * 86400;
      uptime_hour = uptime / 3600;
      uptime -= uptime_hour * 3600;
      uptime_minute = uptime /60;
      pvPut(uptime_day);
      pvPut(uptime_hour);
      pvPut(uptime_minute);

      festat = pEpics->epicsOutput.fe_status;
%%    if(festat == -10) strcpy(msgFESTAT,"IPC Init ERROR ");
%%    if(festat == -9) strcpy(msgFESTAT,"IO Card Map ERROR ");
%%    if(festat == -8) strcpy(msgFESTAT,"IO Config ERROR ");
%%    if(festat == -7) strcpy(msgFESTAT,"ADC Timeout - exiting");
%%    if(festat == -6) strcpy(msgFESTAT,"DAC Init Failed - exiting");
%%    if(festat == -5) strcpy(msgFESTAT,"BURT Restore Failed - exiting");
%%    if(festat == -4) strcpy(msgFESTAT,"Channel Hopping detected - exiting");
%%    if(festat == -3) strcpy(msgFESTAT,"Running on Timer");
%%    if(festat == -2) strcpy(msgFESTAT,"DAQ init failed - exiting");
%%    if(festat == -1) strcpy(msgFESTAT,"Failed to init filter coeffs - exiting");
%%    if(festat == 0) strcpy(msgFESTAT,"Loading");
%%    if(festat == 1) strcpy(msgFESTAT,"Initializing PCIE cards");
%%    if(festat == 2) strcpy(msgFESTAT,"Waiting for BURT restore");
%%    if(festat == 3) strcpy(msgFESTAT,"Locking Core");
%%    if(festat == 4) strcpy(msgFESTAT,"Initializing ADC modules");
%%    if(festat == 5) strcpy(msgFESTAT,"Initializing DAC modules");
%%    if(festat == 6) strcpy(msgFESTAT,"Waiting to Sync");
%%    if(festat == 7) strcpy(msgFESTAT,"  ");
%%    if(festat == 8) strcpy(msgFESTAT,"IOC SLOT CHECK IN PROGRESS");
%%    if(festat == 9) strcpy(msgFESTAT,"In state 9");
      pvPut(msgFESTAT);

%%    pthread_mutex_lock (&seq_lock);

//
// This version of the coefficient load is called when the "LOAD COEFFICIENTS"
// button is pressed on the filter module medm, and only loads one module at a time.
//
//
#if MAX_MODULES > 0
%%    for(ii=0;ii<MAX_MODULES;ii++){
%%      double t;
        pvGet(swRset[ii]);
        if(swRset[ii]&1)
%% 	    {
	        strcpy(msg, "Reading coeff file...");
	        pvPut(msg);
%%	        printf("Calling partial load with: \n\t%s\n\t%s\n\t%s\n",cfdir,cfmodel,fmmap0[ii].name);
%%	        int status = fmCreatePartial(cfdir, cfmodel,fmmap0[ii].name);
%%	        /* printf("About to read file \n"); */
%%	        if (fmReadCoeffFile(&fmc, 0, pEpics->epicsOutput.timeDiag, 0) != 0) {
%%	            fprintf(stderr, "Error: %s\n", fmReadErrMsg());
	            strncpy(msg, fmReadShortErrMsg(), MAX_STRING_SIZE-1);
%%              g_filterError |= FILTER_FILE_READ_ERR;
                pvPut(msg);
%%	        } else {
%%              g_filterError &= ~FILTER_FILE_READ_ERR; //Clear error
#if !defined(RFM_EPICS)
%%	            /* Successful coeff reload */
	            sprintf(msg, "%s Complete", fmmap0[ii].name);
                /* Load filter names to EPICS */
%%              copy_labels(ii);
                pvput_labels(ii);
	            initVars(pFilt, pFilt,&coeffSpace, MAX_MODULES, pVmeCoeff);
#else
%%	            int kk;
                //Signal loas new coeff
%%	            pFilt->coef_load_error = 0;
%%              pFilt->inputs[ii].rset = FM_OP_IN_NEW_COEF_RDY;
%%              pFilt->fm_pending_action_index = ii;

%%              //Wait for RT module to perform action, or timeout
%%              for (kk=0; pFilt->fm_pending_action_index != -1 && kk < 2000; ++kk) {
%%                  usleep(100);
%%              }
%%              if ( kk == 2000 ) { //Timeout
%%                  g_filterError |= FILTER_FE_TIMOUT_ERR;
                    strcpy(msg, "Error: Front-end timeout");
                    pvPut(msg);
%%                  break;
%%              }
%%              else {
%%                  //fprintf(stderr, "It took %d loops to load the filters\n", kk);
%%                  g_filterError &= ~FILTER_FE_TIMOUT_ERR;
%%              }


%%              if( pFilt->coef_load_error == -1 ) { //Filter load error reported by RT module
%%                  g_filterError |= FILTER_TRANSMISSION_ERR;
                    sprintf(msg, "Error: %s Transmission Error", fmmap0[ii].name);
                    pvPut(msg);
%%                  goto bailout2;
%%              } else { //Successful coeff reload
%%                  g_filterError &= ~FILTER_TRANSMISSION_ERR;
                    sprintf(msg, "%s Complete", fmmap0[ii].name); //msg gets pvPut in bailout2
%%                  copy_labels(ii);
                    pvput_labels(ii);
%%          }

%%
#endif
%%  	    }
%%          bailout2:
	            pvPut(msg);
	            /* set switch back to zero */
	            swRset[ii] = 0;
	            pvPut(swRset[ii]);
%%      }

	    swStatus[ii] = pFilt->data[ii].swStatus;
	    pvGet(swMask[ii]);
	    pvGet(swReq[ii]);
%%      if(swMask[ii])
%%      {
%%	        int smask = swMask[ii];
%%	        int sreq = swReq[ii];
%%	        int sstat = swStatus[ii];
%%	        for(jj = 0; jj<17;jj++)
%%	        {
%%		        if(smask & 1)
%%		        {
%%			        if((sreq & 1) != (sstat & 1))
%%			        {
%%				        swStatus[ii] |= 0x40000;
%%			        }
%%		        }
%%		        smask >>= 1;
%%		        sreq >>= 1;
%%		        sstat >>= 1;
%%	        }
%%      }
	
        /* Check for history reset */
        if(swRset[ii]&2)
%%      {
	        /* set switch back to zero */
%%	        /*printf("resetting history for module %d\n",ii);*/
%%	        pFilt->inputs[ii].rset = FM_OP_IN_RSET_HISTORY;
	        swRset[ii] = 0;
	        pvPut(swRset[ii]);
	        swStatus[ii] |= 0x20000;
%%      }
	    pvPut(swStatus[ii]);


        /* Get saved switch settings, used for burt purposes */
        pvGet(saveSwitch1[ii]);  
        pvGet(saveSwitch2[ii]);  

        /* Get filter switch selections */
        pvGet(sw1[ii]);
        pvGet(sw2[ii]);	

%%      unsigned int msk = pFilt->inputs[ii].mask;
%%      unsigned int msk_s = msk & 0xffff;;
%%      unsigned int control = pFilt->inputs[ii].control;
        if ((saveSwitch1[ii] & msk_s) != (control & 0xffff))
%%      {
	        saveSwitch1[ii] = (control & msk_s) | (saveSwitch1[ii] & ~msk_s);
      	    pvPut(saveSwitch1[ii]);  
%%      }
        if(sw1[ii]) {
            saveSwitch1[ii] ^= (sw1[ii] & ~msk_s);
      	    sw1[ii] = 0;
      	    pvPut(sw1[ii]);  
      	    pvPut(saveSwitch1[ii]);  
        }
        msk >>=16; control >>= 16;
%%      msk_s = msk & 0xffff;;
        if ((saveSwitch2[ii] & msk_s) != (control & 0xffff))
%%      {
	        saveSwitch2[ii] = (control & msk_s) | (saveSwitch2[ii] & ~msk_s);
      	    pvPut(saveSwitch2[ii]);  
%%      }
        if(sw2[ii])
%%      {
            saveSwitch2[ii] ^= (sw2[ii] & ~msk_s);
      	    sw2[ii] = 0;
      	    pvPut(sw2[ii]);  
      	    pvPut(saveSwitch2[ii]);  
%%      }

%%      int getSwitch1, getSwitch2;

        /* Get switch readbacks from Pentium */
%%	    getSwitch1 = ((pFilt->inputs[ii].opSwitchP)&(mask[0]));
%%    	getSwitch2 = (((pFilt->inputs[ii].opSwitchP) >> 16)&(mask[1]));
      	switchR1[ii] = ((getSwitch1)|(0x555f&saveSwitch1[ii]));
	    switchR2[ii] = ((getSwitch2)|(0xf55&saveSwitch2[ii]));
%%      rfm_assign(pFilt->inputs[ii].opSwitchE, (switchR2[ii] << 16) + switchR1[ii]);
        pvPut(switchR1[ii]);  
        pvPut(switchR2[ii]);

%%      /*get/set everything else*/
%%	    t = fpvalidate(pFilt->data[ii].filterInput);
        input[ii] = t;
%%	    t = fpvalidate(pFilt->data[ii].exciteInput);
	    excite[ii] = t;
/*
	    input[ii] *= conv;
	    excite[ii] *= conv;
*/
        pvPut(input[ii]);
	    pvPut(excite[ii]);

	    if (msk & 0x8000) { /* Ramp time is controlled locally by the FE */
%%		    gain_ramp_time[ii] = pFilt->inputs[ii].gain_ramp_time;
		    pvPut(gain_ramp_time[ii]);
	    } else {
		    pvGet(gain_ramp_time[ii]);
%%		    rfm_assign(pFilt->inputs[ii].gain_ramp_time, gain_ramp_time[ii]);
	    }

	    if (msk & 0x2000) { /* Offset is controlled locally by the FE */
%%		    offset[ii] = pFilt->inputs[ii].offset;
		    pvPut(offset[ii]);
	    } else {
		    pvGet(offset[ii]);
%%		    rfm_assign(pFilt->inputs[ii].offset, offset[ii]);
	    }

	    if (msk & 0x4000) { /* Gain is controlled locally by the FE */
%%		    outgain[ii] = pFilt->inputs[ii].outgain;
		    pvPut(outgain[ii]);
	    } else {
		    pvGet(outgain[ii]);
%%		    rfm_assign(pFilt->inputs[ii].outgain, outgain[ii]);
	    }

	    pvGet(limit[ii]);
%%	    rfm_assign(pFilt->inputs[ii].limiter, limit[ii]);
%%	    t = fpvalidate(pFilt->data[ii].testpoint);
	    tp[ii] = t;
	    /*tp[ii] = pFilt->data[ii].testpoint;*/
%%	    t = fpvalidate(pFilt->data[ii].output16Hz)/* * conv*/;
	    out16Hz[ii] = t;
	    pvPut(out16Hz[ii]);
%%	    t = fpvalidate(pFilt->data[ii].output);
	    output[ii] = t;
	    pvPut(tp[ii]);
	    pvPut(output[ii]);


#if !defined(RFM_EPICS)
    	pvGet(epics_exc[ii]);
#if defined(SEQUENCER_NAME_tcsh1) || defined(SEQUENCER_NAME_tcsh2)
%%	    switch(ii) {
%%		case 0:
    	    pvGet(tcs1Input);
    		pvGet(tcs2Input);
%%			inpt = tcs1Input * pEpicsSpace.inmtrx[0][0]
%%			      + tcs2Input * pEpicsSpace.inmtrx[1][0];
%%			break;
%%		case 1:
%%			inpt = tcs1Input * pEpicsSpace.inmtrx[0][1]
%%			      + tcs2Input * pEpicsSpace.inmtrx[1][1];
%%			break;
%%		case 2:
%%			inpt = outpts[0] * pEpicsSpace.outmtrx[0][0]
%%			       + outpts[1] * pEpicsSpace.outmtrx[1][0];
%%			break;
%%		case 3:
%%			inpt = outpts[0] * pEpicsSpace.outmtrx[0][1]
%%			       + outpts[1] * pEpicsSpace.outmtrx[1][1];
    		pvGet(tcsEnable);
%%			break;
%%	    }
#else
    	pvGet(epics_input[ii]);
	    inpt = epics_input[ii];
#endif
%%  	pFilt->data[ii].exciteInput = epics_exc[ii];
%%	    checkFiltReset(ii, pFilt, pFilt, &coeffSpace, MAX_MODULES, pVmeCoeff);
%%  	outpts[ii] =
%%	        filterModuleD(pFilt,     /* Filter module data  */
%%          &coeffSpace,            /* Filter coefficients */
%%          ii,          /* Filter module number */
%%	        inpt,
%%          0); /* system id */
#if defined(SEQUENCER_NAME_tcsh1) || defined(SEQUENCER_NAME_tcsh2)
%%	    if (ii == 3) {
%%	        if (tcsEnable) {
%%	            tcsXOutput = outpts[2];
%%	            tcsYOutput = outpts[3];
	            pvPut(tcsXOutput, SYNC);
	            pvPut(tcsYOutput, SYNC);
%%	        }
%% 	    }
#endif
#endif

%%    }
#endif


%DECL4%

      pvPut(epicsSyncTime);

%%    time_t lt = time(0);
%%    strcpy(localtimestring, ctime(&lt));
%%    localtimestring[strlen(localtimestring) - 1] = 0; /* Delete newline character */
      pvPut(localtimestring);


%%    pthread_mutex_unlock (&seq_lock);
#ifndef NO_DAQ_IN_SKELETON
  }state daqProcess
#else
  }state filtCoefChk
#endif
}

#ifndef NO_DAQ_IN_SKELETON
state daqInit
{
  when()
    {
%%      strcpy(fNameDAQ, "/opt/rtcds/");                                 /* ma */
%%      strcat_lower(fNameDAQ, fmc.site);                                /* ma */
%%      strcat(fNameDAQ, "/");                                           /* ma */
%%      strcat_lower(fNameDAQ, fmc.ifo);                                 /* ma */
%%      strcat(fNameDAQ, "/chans/daq/");                                 /* ma */
%%      strcat_upper(fNameDAQ, fmc.system);                              /* ma */
%%      if (strlen(fmc.subSys[0].name) > 0) {                            /* ma */
%%         strcat(fNameDAQ, "_");                                        /* ma */
%%         strcat_upper(fNameDAQ, fmc.subSys[0].name);                   /* ma */
%%      }                                                                /* ma */
%%      strcat(fNameDAQ, ".ini");                                        /* ma */

        dcuId = atoi(macValueGet("sysnum"));
%%      if (dcuId < 0 || dcuId >= DCU_COUNT) {
%%        fprintf(stderr, "Invalid system number %d\n", dcuId);
%%        exit(1);
%%      }
        strcpy(site, macValueGet("site"));
        strcpy(ifo, macValueGet("ifo"));
        strcpy(daqsys, macValueGet("sysfile"));

%%      strcpy(system_lower, daqsys);
%%      for(s_hold = system_lower; *s_hold; s_hold++) *s_hold=tolower(*s_hold);
%%
%%      g_base_shm_handle = shmem_open(system_lower, DEFAULT_SHMEM_ALLOC_SIZE_MB);
%%      if (g_base_shm_handle == 0) {
%%          fprintf(stderr, "shmem_open failed, buffer name %s.\n", system_lower);
%%          exit(1);
%%      }
%% 
%%      base = shmem_mapping(g_base_shm_handle);
%%      info = (DAQ_INFO_BLOCK *)(base + DAQ_INFO_ADDRESS);
        pvPut(dcuId);
%%      rfm_assign(pEpics->epicsInput.dcuId, dcuId);
%%      printf("daq info at 0x%lx\n",(unsigned long)info);
%%      memset(&infoTmp, 0, sizeof(infoTmp));
%%      info->reconfig = 0;
%%      g_daq_loaded = 0;
%%      if (loadDaqConfigFile(&infoTmp, &gdsTmp,site, ifo, daqsys)) {
%%         g_daq_loaded = 1;
           strcpy(msgDAQ, localtimestring);
%%         copy_info();
%%         copy_gds_info();
%%         printf("Total gds tp = %d\n",gdsTmp.totalchans);
%%         printf("%s%s daqConfig info is at rfm offset 0x%lx\n", ifo, daqsys, ((char *)info) - ((char *)base));
%%         info -> reconfig = 1;
%%         chnCnt = infoTmp.numChans;
%%         epicschnCnt = infoTmp.numEpicsInts + infoTmp.numEpicsFloats + infoTmp.numEpicsFilts;
%%         dataSize = 0;
%%         { int i;
%%              for(i=0; i < infoTmp.numChans; i++) {
%%                      dataSize += infoTmp.tp[i].dataRate * DAQ_DATA_TYPE_SIZE(infoTmp.tp[i].dataType);
%%              }
%%         }
%%		dataSize += 64 * (infoTmp.numEpicsInts + infoTmp.numEpicsFloats + infoTmp.numEpicsFilts);
%%         dataSize /= 1000;
           strcpy(msgDAQ, localtimestring);
%%      } else {
           strcpy(msgDAQ, "ERROR reading DAQ file!");
%%         /*chnCnt = 0;*/
%%         /*dataSize = 0;*/
%%      }

        pvPut(dcmsg);
        pvPut(chnCnt);
        pvPut(epicschnCnt);
        pvPut(dataSize);
        pvPut(msgDAQ);
    } state monScreen
}

state gdsmon_update
{
  when()
    {
%% 	int monval,ii,jj;
%% pthread_mutex_lock (&seq_lock);
%%  
%% for(ii=0;ii<32;ii++) { 
%%    monval = pEpics->epicsOutput.gdsMon[ii];
%%    if( last_gds_tp[ii] != monval)
%%    {
%%     last_gds_tp[ii] = monval;
%%        if(monval == 0) 
%%        {
%%            strcpy(gdsmon_str[ii],"");
            pvPut( gdsmon_str[ii] );
%%        } else {
%%          for(jj=0;jj<gdsInfo->totalchans;jj++) { 
%%                if(gdsInfo->tpinfo[jj].tpnumber == monval)
%%                {
%%                    strcpy(gdsmon_str[ii],gdsInfo->tpinfo[jj].tpname);
                    pvPut( gdsmon_str[ii] );
%%                }
%%            }
%%        }
%%    }
%%    }
%% pthread_mutex_unlock (&seq_lock);
   } state monScreen
} 

state daqProcess
{
  when()
    {
%%      int modDAQ;                                                      /* ma */
%%	static unsigned int cksum_cnt = 0;

%% pthread_mutex_lock (&seq_lock);

        pvGet(reload);
        if (reload)
%%        {
%%          info -> reconfig = 0;
            strcpy(msgDAQ, "Reading DAQ (.ini) file...");
            pvPut(msgDAQ);
%%          g_daq_loaded = 0;
%%          if (loadDaqConfigFile(&infoTmp, &gdsTmp, site, ifo, daqsys)) {
%%            g_daq_loaded = 1;
%%            copy_info();
%%            copy_gds_info();
%%		printf("Total gds tp = %d\n",gdsTmp.totalchans);
%%            printf("%s%s daqConfig info is at rfm offset 0x%lx\n", ifo, daqsys, ((char *)info) - ((char *)base))
;
%%            info -> reconfig = 1;
%%            chnCnt = infoTmp.numChans;
%%         epicschnCnt = infoTmp.numEpicsInts + infoTmp.numEpicsFloats + infoTmp.numEpicsFilts;
%%            dataSize = 0;
%%            { int i;
%%              for(i=0; i < infoTmp.numChans; i++) {
%%                      dataSize += infoTmp.tp[i].dataRate * DAQ_DATA_TYPE_SIZE(infoTmp.tp[i].dataType);
%%              }
%%            }
%%		dataSize += 64 * (infoTmp.numEpicsInts + infoTmp.numEpicsFloats + infoTmp.numEpicsFilts);
%%            dataSize /= 1000;
%%            sleep(1);
              strcpy(msgDAQ, localtimestring);
%%          } else {
		pvGet(chnCnt);
		pvGet(dataSize);
              strcpy(msgDAQ, "ERROR reading DAQ file!");
%%          }
            pvPut(chnCnt);
            pvPut(epicschnCnt);
            pvPut(dataSize);
            pvPut(msgDAQ);
%%        }
        reload = 0;
        pvPut(reload);
%% pthread_mutex_unlock (&seq_lock);

    } state filtCoefChk
}
#endif

state filtCoefChk
{
  when()
    {
%% 	int mod,ii;
%% pthread_mutex_lock (&seq_lock);
%%  
   /* Coefficient update request */	
    pvGet(allNewCoeff);
    if(allNewCoeff)
%%  {
   	    pvGet(localtimestring);
%% 	    int status = system(cpCmd);
%%      if ( status != 0 ) {
%%          g_filterError |= FILTER_COPY_ERR;
            sprintf(msg, "Error: Could not cp filter file");
            pvPut(msg);
%%          goto bailout1;
%%      }
%%      else { 
%%          g_filterError &= ~FILTER_COPY_ERR;
%%      }
%% 	    printf("copy file with status = %d\n",status);
%%      fprintf(stderr, "%s READING COEFF FILE\n",localtimestring);
%%	    strcpy(msg, "Reading coeff File...");
	    pvPut(msg);
%%      /* printf("About to read file \n"); */
%%      if (fmReadCoeffFile(&fmc, 0, pEpics->epicsOutput.timeDiag, 0) != 0) {
%%          fprintf(stderr, "Error: %s\n", fmReadErrMsg());
%%          g_filterError |= FILTER_FILE_READ_ERR;

            strncpy(msg, fmReadShortErrMsg(), MAX_STRING_SIZE-1);
            pvPut(msg);
%%	    } else {
%%          g_filterError &= ~FILTER_FILE_READ_ERR; //Clear error
#if !defined(RFM_EPICS)
%%	        /* Successful coeff reload */
	        sprintf(msg, "Coeff load complete");
#if MAX_MODULES > 0
            /* Load filter names to EPICS */
%%          for (ii=0;ii<MAX_MODULES;ii++) {
%%            	copy_labels(ii);
                pvput_labels(ii);
%%	        }
#endif
	        initVars(pFilt, pFilt,&coeffSpace, MAX_MODULES, pVmeCoeff);
#else

//
// This version of the coefficient load is called when the "COEFF LOAD"
// button is pressed on the GDS_TP medm, and loads each filter in the model.
//

#if MAX_MODULES > 0
%%      for (ii=0;ii<MAX_MODULES;ii++) {
%%	        int kk;
%%	        pFilt->coef_load_error = 0;
%%          /* Send new coeff flags to Pentium */
%%          pFilt->inputs[ii].rset = FM_OP_IN_NEW_COEF_RDY;
%%          pFilt->fm_pending_action_index = ii;

%%          //Wait for RT module to perform action, or timeout
%%          for( kk=0; pFilt->fm_pending_action_index != -1 && kk < 2000; ++kk) {
%%              usleep(100);
%%          }
%%          if ( kk == 2000 ) { //Timeout
%%              g_filterError |= FILTER_FE_TIMOUT_ERR;
                strcpy(msg, "Error: Front-end timeout");
                pvPut(msg);
%%              break;
%%          }
%%          else {
%%              //fprintf(stderr, "It took %d loops to load the filters\n", kk);
%%              g_filterError &= ~FILTER_FE_TIMOUT_ERR;
%%          }
%%
%%

%%          if( pFilt->coef_load_error == -1 ) { //Filter load error reported by RT module
%%              g_filterError |= FILTER_TRANSMISSION_ERR;
                sprintf(msg, "Error: %s Transmission Error", fmmap0[ii].name);
                pvPut(msg);
%%              goto bailout1;
%%          } else { //Successful coeff reload
%%              g_filterError &= ~FILTER_TRANSMISSION_ERR;
                sprintf(msg, "%s Complete", fmmap0[ii].name);
                pvPut(msg);
%%              copy_labels(ii);
                pvput_labels(ii);
%%          }

%%
%%
%%
%%


%%      } //Loop over all filter modules
#endif
#endif
%%	bailout1:
        pvGet(localtimestring);
%%	     if (ii == MAX_MODULES) {
		    strcpy(msg, localtimestring);
            pvPut(msg);
%%	     }
%%	  }
          allNewCoeff = 0;
          pvPut(allNewCoeff);
%%    }
%% pthread_mutex_unlock (&seq_lock);
    } state gdsmon_update
}

}
