static char *versionId = "Version $Id$" ;
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: gdstask							*/
/*                                                         		*/
/* Module Description: functions for handling tasks & semaphores	*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

/* Header File List: */
#include <stdlib.h>


/* #include "gdsutil.h" */
#include "dtt/gdstask.h"


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* External Procedure Name: taskCreate					*/
/*                                                         		*/
/* Procedure Description: spawns a new task				*/
/*                                                         		*/
/* Procedure Arguments: attr - 	thread attr. detached/process (UNIX);	*/
/*				all task attr. (VxWorks)		*/
/* 			priority - thread/task priority			*/
/* 			taskIF - pointer to TID (return value)		*/
/* 			task - thread/task function			*/
/* 			arg - argument passed to the task		*/
/*                                                         		*/
/* Procedure Returns: 0 if succesful, -1 if failed			*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
   int taskCreate (int attr, int priority, taskID_t* taskID, 
                  const char* taskname, taskfunc_t task, taskarg_t arg)
   {

      /* POSIX task */
      {
         pthread_attr_t		tattr;
         struct sched_param	schedprm;
         int			status;
      
      	/* set thread parameters: joinable & system scope */
         if (pthread_attr_init (&tattr) != 0) {
            return -1;
         }
         pthread_attr_setdetachstate (&tattr, 
                              attr & PTHREAD_CREATE_DETACHED);
         pthread_attr_setscope (&tattr, attr & PTHREAD_SCOPE_SYSTEM);
      	 /* set priority */
         pthread_attr_getschedparam (&tattr, &schedprm);
         schedprm.sched_priority = priority;
         pthread_attr_setstacksize(&tattr, 1048576);
         pthread_attr_setschedparam (&tattr, &schedprm);
      
         /* create thread */
         status = pthread_create (taskID, &tattr, task, (void*) arg);
         pthread_attr_destroy (&tattr);
         if (status != 0) {
            return -1;
         }
      }
      return 0;
   }


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* External Procedure Name: taskCancel					*/
/*                                                         		*/
/* Procedure Description: cancels a task				*/
/*                                                         		*/
/* Procedure Arguments: taskID - pointer to TID (return value)		*/
/*                                                         		*/
/* Procedure Returns: 0 if succesful, -1 if failed			*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
   int taskCancel (taskID_t* taskID)
   {
      if ((taskID == NULL) || (*taskID == 0)) {
         return 0;
      }
      /* cancel task */
      if (pthread_cancel (*taskID) != 0) {
         return -1;
      }
      *taskID = 0;
      return 0;
   }
