/* Version: $Id$ */
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: rpcinc.h						*/
/*                                                         		*/
/* Module Description: rpc include patch 				*/
/* Used to fix include file discrepancies between UNIX and VxWorks	*/
/*                                                         		*/
/* Module Arguments: none				   		*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 1.0	 13Apr98  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: gdssched.html					*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8336  (509) 372-2178  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/* Code Compilation and Runtime Specifications:				*/
/*	Code Compiled on: Ultra-Enterprise, Solaris 5.5.1		*/
/*	Compiler Used: sun workshop C 4.2				*/
/*	Runtime environment: sparc/solaris				*/
/*                                                         		*/
/* Code Standards Conformance:						*/
/*	Code Conforms to: LIGO standards.	OK			*/
/*			  Lint.			TBD			*/
/*			  ANSI			OK			*/
/*			  POSIX			OK (uses rpc)		*/
/*									*/
/* Known Bugs, Limitations, Caveats:					*/
/*								 	*/
/*									*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1996.			*/
/*                                                         		*/
/*                                                         		*/
/* California Institute of Technology			   		*/
/* LIGO Project MS 51-33				   		*/
/* Pasadena CA 91125					   		*/
/*                                                         		*/
/* Massachusetts Institute of Technology		   		*/
/* LIGO Project MS 20B-145				   		*/
/* Cambridge MA 01239					   		*/
/*                                                         		*/
/* LIGO Hanford Observatory				   		*/
/* P.O. Box 1970 S9-02					   		*/
/* Richland WA 99352					   		*/
/*                                                         		*/
/* LIGO Livingston Observatory		   				*/
/* 19100 LIGO Lane Rd.					   		*/
/* Livingston, LA 70754					   		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

#ifndef __EXTENSIONS__
#define __EXTENSIONS__
#endif
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif

#ifndef _REENTRANT
#define _REENTRANT
#endif


/** @name Remote Procedure Call Interface
    This module fixes inconsitencies between the rpc interface 
    running on Solaris and on VxWorks. This include header should be
    used instead of the usual ones generated by the rpcgen program
    (see the rpc help page under 'patches and fixes' in the 'development
    environment' section on how to patch rpcgen output automatically).

    This header file also fixes compatibility problems of the rpcgen 
    output with POSIX.1c on Solaris and the VxWorks multitasking
    environment.

    Addiitonally, this module exports commonly used rpc functions
    to handle with host and client addresses and with starting and 
    registering and rpc service.

    Generally, there is no need to include this header file in the
    main rpc programs, but rather it should be read in by the files
    which are generated by the rpcgen program.
   
    @memo Utility functions and fixes for the rpc interface
    @author Written July 1998 by Daniel Sigg
    @version 1.0
************************************************************************/

/*@{*/	

/** @name Constants and flags
    Constants and flags used by the remote procedure call interface.

    @memo Constants and flags
    @author DS, July 98
    @see Remote Procedure Call Interface, Patches
************************************************************************/

/*@{*/

/** @name _RPC_HDR
    If this constant is defined before the include directive, the 
    rpc header file fixes and patches are read in - together with 
    additional rpc utility functions.

    The following problems are fixed:

    1) header file inconsistencies between UNIX and VxWorks,

    2) support for long long data types on VxWorks.

    @memo rpc header file fixes and utilities
    @author DS, July 98
    @see Remote Procedure Call Interface, Patches
************************************************************************/

/** @name _RPC_SVC
    If this constant is defined before the include directive, the 
    fixes and patches for the rpc server file are read in.

    The following problems are fixed:

    1) header file inconsistencies between UNIX and VxWorks,

    2) compatibility of semaphores generated by 'rpcgen' with the 
    POSIX.1c standard on Solaris,

    3) compatibility of semaphores generated by 'rpcgen' with the 
    VxWorks environment,

    4) wrapper for the syslog function on VxWorks.

    @memo rpc server file fixes
    @author DS, July 98
    @see Remote Procedure Call Interface, Patches
************************************************************************/

/** @name _RPC_CLNT
    If this constant is defined before the include directive, the 
    fixes and patches for the rpc client file are read in.

    The following problems are fixed:

    1) header file inconsistencies between UNIX and VxWorks.

    @memo rpc client file fixes
    @author DS, July 98
    @see Remote Procedure Call Interface, Patches
************************************************************************/

/** @name _RPC_XDR
    If this constant is defined before the include directive, the 
    fixes and patches for the rpc xdr file are read in.

    The following problems are fixed:

    1) support of XDR routines for long long data types on VxWorks.

    @memo rpc xdr file fixes
    @author DS, July 98
    @see Remote Procedure Call Interface, Patches
************************************************************************/


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Include target: rXXX.h						*/
/*                                                         		*/
/* fixes includes for rpc/rpc.h and rpc/pmap_clnt.h			*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#ifdef _RPC_HDR

#ifndef _GDS_RPCINCH_H
#define _GDS_RPCINCH_H

#ifdef __cplusplus
extern "C" {
#endif

#include <rpc/rpc.h>
#ifndef __longlong_t__
#define longlong_t long long
#endif
#ifndef __u_longlong_t__
#define u_longlong_t unsigned long long
#endif



#include <rpc/pmap_clnt.h>

#include "gdstask.h"

/** Default timeout for the rpcProbe function (in sec).

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROBE_WAIT		1

/** Default program number for the test point server. The default 
    program number is 0x31001001.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_TESTPOINT	0x31002000

/** Default version number for the test point server. The default 
    version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_TESTPOINT	1

/** Default program number for the arbitrary waveform generator. The 
    default program number is 0x31001002.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_AWG		0x31003000

/** Default version number for the arbitrary waveform generator. The 
    default version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_AWG		1

/** Default program number for the diagnostics data server. The default 
    program number is 0x31001003.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_RTDD	0x31001003

/** Default version number for the diagnostics data server. The default 
    version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_RTDD	1

/** Default program number for the diagnostics message server. The 
    default program number is 0x31001004.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_GDSMSG	0x31001004

/** Default version number for the diagnostics message server. The 
    default version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_GDSMSG	1

/** Default program number for the diagnostics channel database server. 
    The default program number is 0x31001005.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_GDSCHN	0x31001005

/** Default version number for the diagnostics channel database server. 
    The default version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_GDSCHN	1

/** Default program number for the leap second information server. 
    The default program number is 0x31001006.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_GDSLEAP	0x31001006

/** Default version number for the leap second information server. 
    The default version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_GDSLEAP	1

/** Default program number for the launch server. 
    The default program number is 0x31001007.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGNUM_LAUNCH	0x31001007

/** Default version number for the launch server. 
    The default version number is 1.

    @author DS, August 98
    @see Remote Procedure Call Interface
************************************************************************/
#define RPC_PROGVER_LAUNCH	1

/*@}*/


/** @name Types
    Types of the Remote Procedure Call Interface.

    @memo Types
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/

/*@{*/

/** Dispatch function prototype. Dispatch functions can be automatically
    generated with the 'rpcgen' program (see the "Solaris 2.6: ONC+ 
    Developer's Guide" for further details).

    @param reqsvc requested service
    @param transp service handle
    @return void
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
   typedef void (*rpc_dispatch_t) (struct svc_req* reqsvc, 
                                   register SVCXPRT* transp);

/*@}*/

/** @name Functions
    Functions of the Remote Procedure Call Interface.

    @memo Functions
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/

/*@{*/

/** Returns the host ip address. The host name can be any valid name
    of the host. This function will try to find its ip address by first
    looking in the local database and then quering the DNS.

    @param hostname name of the host computer
    @param addr returned ip address of host
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcGetHostaddress (const char* hostname, struct in_addr* addr);

/** Returns the local host ip address.

    @param addr returned ip address of host
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcGetLocaladdress (struct in_addr* addr);

/** Returns the client ip address. This routine returns the client 
    ip address when the rpc service handle is known. This is mostly
    useful when establishing callback rpc routines.

    @param xprt rpc service handle
    @param clntaddr returned ip address of client
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcGetClientaddress (const SVCXPRT* xprt,
                         struct in_addr* clntaddr);

/** Initializes an rpc server. For TI-RPC implementations the server
    mode can be set to automatically start a new thread for every
    incoming rpc request. On UNIX systems an rpc server may be started 
    from the command line or an rpc monitor. When started from the
    command line the 'scv_fg' flag determines whether the program runs
    in the fore- or background. This routine returns a transport
    handle (all implementations) and a protocol type (non TI-RPC only).

    This routine does not register a service function nor does it
    call svc_run().

    @param rpcpmstart returns 1 if started by a port monitor
    @param svc_fg if 1 the service is started as a foreground task 
           (UNIX only)
    @param svc_mode can be RPC_SVC_MT_AUTO (UNIX only)
    @param transp returned transport handle
    @param proto returned protocol type (non TI-RPC only)
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcInitializeServer (int* rpcpmstart, int svc_fg, int svc_mode,
                         SVCXPRT** transp, int* proto);

/** Registers an rpc service. After the initialization of the rpc
    server, this routine registers an rpc service handler. Usually,
    the rpc service handler is automatiacally generated by the 
    'rpcgen' program. More than one rpc service handler can be 
    registered. After registration the rpc server program usually
    calls svc_run() to wait for rpc calls.

    @param rpcpmstart 1 if started by a port monitor
    @param transp transport handle
    @param proto protocol type (non TI-RPC only)
    @param prognum rpc program number used for registration
    @param progver rpc program version used for registration
    @param service service handler routine (usually generated by rpcgen)
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcRegisterService (int rpcpmstart, SVCXPRT* transp, int proto,
	        unsigned long prognum, unsigned long progver,
		rpc_dispatch_t service);


/** Set rpc server into busy state. If the shutdown flag is NULL or 
    pointing to zero, the server will shut down after approximately 
    60 sec, if it was started by a port monitor and if the busy flag 
    was not set during the last 60 sec.

    @param busyflag if non-zero server is set to busy state
    @return void
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
void rpcSetServerBusy (int busyflag);
   

/** Starts an rpc server. If started by a port monitor (rpcpmstart = 1),
    the shutdown argument is used to determine when the server should 
    shutdown. The server will not shutdown while the shutdown variable
    has a non-zero value. (If a NULL pointer is provided instead
    a pointer to a valid shutdoown variable, the server will 
    automatically shutdown after about 2 min.) This function never 
    returns.

    Example:
    \begin{verbatim}
  #include rpcinc.h
  extern void mydispatch (struct svc_req*, register SVCXPRT*);

  int main (void) {
    int		rpcpmstart;
    SVCXPRT*	transp;
    int		proto;
    int		shutdown = 0;	 // shutdown after 120 sec

    rpcInitializeServer (&rpcpmstart, 0, -1, &transp, &proto);
		// uses default server mode, works in background
    rpcRegisterService (rpcpmstart, transp, proto, MYPROGNUM,
		        MYPROGVER, mydispatch);
		// registers a service with (MYPROGNUM, MYPROGVER)
    rpcStartServer (rpcpmstart, &shutdown);
		// waits for rpc calls; never returns
  }
    \end{verbatim}
    The above example initializes an rpc server, registers a service
    (MYPROGNUM, MYPROGVER). When called from the command line, the 
    server forks into background and runs foreever. When started
    by a port montor (e.g. indetd), the server waits about 2 min. 
    for additional requests before closing down.

    @param rpcpmstart 1 if started by a port monitor
    @param shutdown pointer to shutdown variable
    @return void
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
void rpcStartServer (int rpcpmstart, int* shutdown);


/** Starts an rpc callback service. The program number is dynamically 
    alocated and returned. But, the rpc program version number has to be 
    specified. This routine also returns a transport handle if successful
    and the task ID of the service task. The callback service is started
    as a separate task with the given priority. The last argument is the 
    dispatch function for the callback service (usually created by 
    rpcgen). A return value of 0 signals a successful start of the
    callback service. This routine calls rpcRegisterCallback to 
    register the callback service.

    @param prognum returned rpc program number of callback
    @param progver rpc program version used for registration
    @param transp returned transport handle
    @param tid returned task ID
    @param priority service task priority
    @param dispatch callback dispatch routine
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcStartCallbackService (u_long* prognum, u_long progver, 
                     SVCXPRT** transport, taskID_t* tid, int priority,
                     rpc_dispatch_t dispatch);

/** Stops an rpc callback service.

    @param prognum rpc program number of callback service
    @param progver rpc program version of callback service
    @param transp transport handle of callback service
    @param tid task ID of callback service
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcStopCallbackService (u_long prognum, u_long progver, 
                     SVCXPRT* transport, taskID_t tid);


/** Registers an rpc callback service. The program numnber is dynamically 
    alocated and returned. But, the rpc program version number has to be 
    specified. This routine also returns a transport handle if successful.
    The last argument is a dispatch function which is usually created by
    rpcgen.

    @param prognum returned rpc program number of callback
    @param progver rpc program version used for registration
    @param transp returned transport handle
    @param dispatch callback dispatch routine (usually generated by rpcgen)
    @return 0 if successful, <0 otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcRegisterCallback (u_long* program, u_long version, 
	 	SVCXPRT** transport, rpc_dispatch_t dispatch);


/** Probes an rpc callback service. Returns true (1) if the service
    exists and false (0) otherwise. If the a non-NULL client pointer 
    pointer is supplied the function will return a client handle to 
    the rpc service if successful and NULL if failed.

    @param host hostname of rpc server
    @param prognum rpc program number of service
    @param progver rpc program version
    @param nettype network ID
    @param timeval maximum time to wait
    @param client pointer to client handle (return)
    @return true (1) if successful, false (0) otherwise
    @author DS, July 98
    @see Remote Procedure Call Interface
************************************************************************/
int rpcProbe (const char* host, const u_long prognum, 
              const u_long versnum, const char* nettype, 
              const struct timeval* timeout, CLIENT** client);


#define inet_ntoa_b(addr, host) \
			strncpy (host, inet_ntoa (addr), 80)


#ifdef __cplusplus
}
#endif

#endif /* _GDS_RPCINCH_H */

#endif


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Include target: rXXX_svc.c						*/
/*                                                         		*/
/* fixes includes and multi-thread routines				*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#ifdef _RPC_SVC

#ifndef _GDS_RPCINCS_H
#define _GDS_RPCINCS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <string.h>

#include <stdio.h>
#include <stdlib.h> 
#include <syslog.h>
#include <pthread.h>

#define mutex_t pthread_mutex_t
#define mutex_lock(mux) pthread_mutex_lock (mux)
#define mutex_unlock(mux) pthread_mutex_unlock (mux) 
#define mutex_trylock(mux) pthread_mutex_trylock (mux)


#ifdef __cplusplus
}
#endif

#endif /* _GDS_RPCINCS_H */

#endif


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Include target: rXXX_clnt.c						*/
/*                                                         		*/
/* fixes includes							*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#ifdef _RPC_CLNT

#ifndef _GDS_RPCINCC_H
#define _GDS_RPCINCC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
}
#endif

#endif /* _GDS_RPCINCC_H */

#endif


/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Include target: rXXX_xdr.c						*/
/*                                                         		*/
/* fixes includes							*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#ifdef _RPC_XDR

#ifndef _GDS_RPCINCX_H
#define _GDS_RPCINCX_H

#ifdef __cplusplus
extern "C" {
#endif

/*@}*/

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _GDS_RPCINCX_H */

#endif

