#ifndef LIGO_DAC_INFO_H
#define LIGO_DAC_INFO_H

#include "portableInline.h"
#include "drv/cdsHardware.h" //CDS_HARDWARE
#include "cds_types.h" //dacInfo_t
#include "controller.h" //cdsPciModules

/**
* This version is called by the control apps
* OR by IOP's configured in virtual IO mode.
*
*/

#ifdef __cplusplus
extern "C" {
#endif

LIGO_INLINE int
dac_status_update( dacInfo_t* dacinfo )
{
    int chan, card;
    int status = 0;

    for ( card = 0; card < cdsPciModules.dacCount; card++ )
    {
        if ( dacinfo->dacOF[ card ] )
        {
            pLocalEpics->epicsOutput.statDac[ card ] &= ~( DAC_OVERFLOW_BIT );
            status |= FE_ERROR_OVERFLOW;

        }
        else
            pLocalEpics->epicsOutput.statDac[ card ] |= DAC_OVERFLOW_BIT;

        dacinfo->dacOF[ card ] = 0;

        //Set DK bit if any DAC channel is killed.
        pLocalEpics->epicsOutput.statDac[ card ] |= DAC_WATCHDOG_BIT;
        if ( dacCardKilled[ card ] )
        {
            status |= FE_ERROR_DAC_KILLED;
            pLocalEpics->epicsOutput.statDac[ card ] &= ~( DAC_WATCHDOG_BIT );
        }
        dacCardKilled[ card ] = 0;

        for ( chan = 0; chan < MAX_DAC_CHN_PER_MOD; chan++ )
        {

            if ( pLocalEpics->epicsOutput.overflowDacAcc[ card ][ chan ] >
                 OVERFLOW_CNTR_LIMIT )
            {
                pLocalEpics->epicsOutput.overflowDacAcc[ card ][ chan ] = 0;
            }
            pLocalEpics->epicsOutput.overflowDac[ card ][ chan ] =
                dacinfo->overflowDac[ card ][ chan ];
            dacinfo->overflowDac[ card ][ chan ] = 0;
        }
    }
    return status;
}

#ifdef __cplusplus
}
#endif



#endif //LIGO_DAC_INFO_H
