use std::env;
use std::path::PathBuf;

fn main() {
    let mut ini_parsing = PathBuf::from(env::var("OUT_DIR").unwrap());
    for _i in 0..6 {
        if !ini_parsing.pop() {
            panic!("cannot create the path to ini_parsing")
        }
    }
    ini_parsing.push("drv");
    println!("cargo:rustc-link-search={}", ini_parsing.to_str().unwrap());
    println!("cargo:rustc-link-lib=static=ini_parsing");
    //println!("cargo:rustc-link-lib=rt");
    println!("cargo:rerun-if-change=wrapper.h");

    let bindings = bindgen::Builder::default()
        .clang_args(["-I../../include"])
        .header("wrapper.h")
        .parse_callbacks(Box::new(bindgen::CargoCallbacks))
        .generate()
        .expect("Unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings");
}
