#ifndef DOLPHIN_DAEMON_ERROR_FORMATTING_HPP
#define DOLPHIN_DAEMON_ERROR_FORMATTING_HPP

#include <fmt/core.h>

#if FMT_VERSION >= 100000

#include <string>
#include <fmt/format.h>
#include "daemon_messages.h"

template <> struct fmt::formatter<enum DOLPHIN_ERROR_CODES>: formatter<std::string>
{
    format_context::iterator
    format(enum DOLPHIN_ERROR_CODES e, fmt::format_context& ctx) const
    {
        const char* value = "unknown error";
        switch (e)
        {
            case DOLPHIN_ERROR_OK:
                value = "ok";
                break;
            case DOLPHIN_ERROR_MALFORMED_MSG:
                value = "malformed message";
                break;
            case DOLPHIN_ERROR_NO_LIBRARY_SUPPORT:
                value = "no library support";
                break;
            case DOLPHIN_ERROR_NO_MCAST_SUPPORT:
                value = "no mcast support";
                break;
            case DOLPHIN_ERROR_SEGMENT_SETUP_ERROR:
                value = "segment setup error";
                break;
            case DOLPHIN_ERROR_SEGMENT_ALREADY_ALLOCATED:
                value = "segment already allocated";
                break;
            case DOLPHIN_ERROR_ADAPTER_NOT_SUPPORTED:
                value = "adapter not supported";
                break;
            case DOLPHIN_ERROR_KERNEL_MODULE_TIMOUT:
                value = "module timout error";
                break;
        }
        return formatter<std::string>::format(value, ctx);
    }
};

#endif // FMT_VERSION

#endif // DOLPHIN_DAEMON_ERROR_FORMATTING_HPP
