//
// Created by jonathan.hanks on 3/16/22.
//

#ifndef DAQD_TRUNK_SIMPLE_PV_INTERNAL_HH
#define DAQD_TRUNK_SIMPLE_PV_INTERNAL_HH

#include <memory>
#include <mutex>

#include "simple_epics.hh"
#include "simple_pv_numeric.hh"

namespace simple_epics
{

    namespace detail
    {
        class setup_string_pv_table;
        /*!
         * @brief A representation of a R/O integer in a PV
         */
        class simpleStringPV : public simplePVBase
        {
            friend class setup_string_pv_table;

        public:
            simpleStringPV( caServer& server, pvStringAttributes attr )
                : simplePVBase( ), server_{ server }, attr_{ std::move(
                                                          attr ) },
                  val_( ), monitored_{ false }
            {
                static std::once_flag initted{ };
                std::call_once( initted, []( ) {
                    simpleStringPV::setup_func_table( );
                } );

                val_ = new gddScalar( gddAppType_value, aitEnumString );
                val_->unreference( );
                update( );
            }
            ~simpleStringPV( ) override;

            caStatus read( const casCtx& ctx, gdd& prototype ) override;
            caStatus write( const casCtx& ctx, const gdd& value ) override;

            void destroy( ) override{ };

            aitEnum bestExternalType( ) const override;

            const char*
            getName( ) const override
            {
                return attr_.name( ).c_str( );
            }

            caStatus interestRegister( ) override;

            void interestDelete( ) override;

            void update( ) override;

        private:
            void set_value( const char* value );

            static void                               setup_func_table( );
            static gddAppFuncTable< simpleStringPV >& get_func_table( );

            gddAppFuncTableStatus
            read_attr_not_handled( gdd& g )
            {
                return S_casApp_success;
            }

            gddAppFuncTableStatus read_severity( gdd& g );

            gddAppFuncTableStatus read_status( gdd& g );

            gddAppFuncTableStatus read_precision( gdd& g );

            gddAppFuncTableStatus read_value( gdd& g );

            caServer&          server_;
            pvStringAttributes attr_;
            smartGDDPointer    val_;
            bool               monitored_;
        };
    } // namespace detail
} // namespace simple_epics

#endif // DAQD_TRUNK_SIMPLE_PV_INTERNAL_HH
