# Simple_frames
A simple interface into FrameCPP.

This allows reading data from a frame.

## Sample code

<pre>
import simple_frames

f = simple_frames.SimpleFrame("frame.gwf")
channels = f.channel_names()
print(f"The first few channels are {0}", channels[0:5])
buf = f.read_channel_as_double("H1:GDS-CALIB_STRAIN")
print(f"The first few datapoints at {0} is {1}", buf.gps_start, buf.data[0:10])

# reading in bulk
bufs = f.read_channels_as_double(["H1:GDS-CALIB_STRAIN", "H1:GDS-CALIB_F_CC"])
print(bufs)
</pre>

## License

This is licensed under the GPL3 or later

## Building

This requires C++, pybind11, python3 dev files, and ldas-tools-framecpp-dev

mkdir build
cd build
cmake ..
make
make install