#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# dttxml documentation build configuration file, created by
# sphinx-quickstart on Sat Jul 15 21:40:50 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
#add the previous folder to the top of path, so that conftest.py can be found
#dirty but does the trick
sys.path.insert(0, os.path.abspath('..'))


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    #'sphinx.ext.todo',
    #'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    #'sphinx.ext.githubpages',
    'sphinx.ext.napoleon',
    'sphinx.ext.viewcode',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'dttxml'
copyright = '2021, LIGO Laboratory'
author = 'Lee McCuller'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '1.1.0'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', ]

# The name of the Pygments (syntax highlighting) style to use.
#pygments_style = 'sphinx'
#pygments_style = 'colorful'
pygments_style = 'default'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# Autodoc settings
autodoc_default_flags = ["members", "undoc-members"]

# -- Options for sourcelinks
srclink_project = 'https://git.ligo.org/CDS/dttxml'
srclink_src_path = 'dttxml'
srclink_branch = 'master'

# -- Options for HTML output ----------------------------------------------

#useful for downloading the ipynb files
html_sourcelink_suffix = ''


html_title = 'dttxml docs'
html_short_title = 'dttxml docs'

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
#import sphinx_rtd_theme
#html_theme = "sphinx_rtd_theme"
#html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

#import jupyter_sphinx_theme
#html_theme = "jupyter_sphinx_theme"
#html_theme_path = [jupyter_sphinx_theme.get_html_theme_path()]

html_theme = "alabaster"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = dict(
    description = "Convert diaggui xml files into usable data structures",
    extra_nav_links = {
        'LIGO CDS repository' : 'https://git.ligo.org/CDS/dttxml'
    },
    show_powered_by = False,
    show_related = True,
    #page_width = 'auto',
)

napoleon_type_aliases = {
    #"CustomType": "mypackage.CustomType",
    #"dict-like": ":term:`dict-like <mapping>`",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'about.html',
        #'globaltoc.html',
        'navigation.html',
        'relations.html',
        'searchbox.html',
    ]
}

# Output file base name for HTML help builder.
htmlhelp_basename = 'dttxml'

html_logo = 'logo/LIGO_F0900035-v1.jpg'

def setup(app):
    app.add_css_file('my_theme.css')
    app.add_css_file('pygments_adjust.css')


