include( CMakeParseArguments )

include( Autotools/cm_msg_notice )
include( Autotools/cm_msg_result )

function(CM_MSG_CHECKING MSG)
  set(options)
  set(oneValueArgs CONDITION )
  set(multiValueArgs SOURCE DEFINES)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  cm_msg_notice( "Checking ${MSG} ... " NO_NL )
  if ( NOT "" STREQUAL "${ARG_CONDITION}" )
    if ( ${ARG_CONDITION} )
      set( _result "yes" )
    else ( ${ARG_CONDITION} )
      set( _result "no" )
    endif ( ${ARG_CONDITION} )
    cm_msg_result( ${_result} )
  endif ( NOT "" STREQUAL "${ARG_CONDITION}" )
endfunction(CM_MSG_CHECKING)
