# A collection of common CMake modules for the LIGO CDS tools

## How to use

The following is a sample CMakeLists.txt for a fictitious sample program.

<pre>
project(sample_program)
cmake_minimum_required( VERSION 3.25 )

set(CMAKE_MODULE_PATH "/usr/share/cds-cmake/cmake/Modules;${CMAKE_MODULE_PATH}")

# program configuration below.  This uses the FindEPICSBase module from cds-cmake
find_package(EPICSBase)

add_executable(sample_program main.cc)
target_link_libraries(sample_program PRIVATE epics::Com epics::ca)
</pre>

### Alternate location method

You can also locate the modules using the GNUInstallDirs iff your CMAKE_INSTALL_PREFIX=/usr *not* /usr/local.
<pre>
include( GNUInstallDirs )
set( CMAKE_MODULE_PATH "${CMAKE_INSTALL_FULL_DATADIR}/cds-cmake/cmake/Modules;${CMAKE_MODULE_PATH}" )
</pre>