
# use pkgconfig to find EPICS Base
find_package(PkgConfig)
pkg_check_modules(EPICS_BASE REQUIRED epics-base>7.0)

if (EPICS_BASE_FOUND)
    set (_epics_calibs_libs_intl "Com;ca")
    set (_epics_caslibs_libs_intl "cas")
    set (_epics_seqlibs_libs_intl "seq;pv;dbRecStd;dbCore")

    set (EPICS_BASE_CAS_LIBS "")
    set (EPICS_BASE_CA_LIBS "")
    set (EPICS_BASE_SEQ_LIBS "")

    foreach (_ca_lib IN LISTS _epics_calibs_libs_intl)
        message("Searching for ${_ca_lib} from ${_epics_calibs_libs_intl}")
        find_library("_concrete_ca_lib_${_ca_lib}" ${_ca_lib} HINTS ${EPICS_BASE_LIBRARY_DIRS})
        message("found ${_concrete_ca_lib_${_ca_lib}}" )
        list(APPEND EPICS_BASE_CA_LIBS "${_concrete_ca_lib_${_ca_lib}}")

        if ("${_concrete_ca_lib_${_ca_lib}}" MATCHES ".*so")
            set(_concrete_ca_type_${_ca_lib} SHARED)
        else()
            set(_concrete_ca_type_${_ca_lib} STATIC)
        endif()

        add_library(epics::${_ca_lib} "${_concrete_ca_type_${_ca_lib}}" IMPORTED GLOBAL)
        set_property(TARGET epics::${_ca_lib} PROPERTY
                IMPORTED_LOCATION "${_concrete_ca_lib_${_ca_lib}}")
        target_include_directories(epics::${_ca_lib} INTERFACE
                "${EPICS_BASE_INCLUDE_DIRS}")
        target_compile_options(epics::${_ca_lib} INTERFACE
                "${EPICS_BASE_CFLAGS_OTHER}")
    endforeach(_ca_lib)
    message("CA LIBS = ${EPICS_BASE_CA_LIBS}")

    foreach (_cas_lib IN LISTS _epics_caslibs_libs_intl)
        message("Searching for ${_cas_lib} from ${_epics_caslibs_libs_intl}")
        find_library("_concrete_cas_lib_${_cas_lib}" ${_cas_lib} HINTS ${EPICS_BASE_LIBRARY_DIRS})
        list(APPEND EPICS_BASE_CAS_LIBS "${_concrete_cas_lib_${_cas_lib}}")
        message("found ${_concrete_cas_lib_${_cas_lib}}" )

        if ("${_concrete_cas_lib_${_cas_lib}}" MATCHES ".*so")
            set(_concrete_cas_type_${_cas_lib} SHARED)
        else()
            set(_concrete_cas_type_${_cas_lib} STATIC)
        endif()

        add_library(epics::${_cas_lib} "${_concrete_cas_type_${_cas_lib}}" IMPORTED GLOBAL)
        set_property(TARGET epics::${_cas_lib} PROPERTY
                IMPORTED_LOCATION "${_concrete_cas_lib_${_cas_lib}}")
        target_include_directories(epics::${_cas_lib} INTERFACE
                "${EPICS_BASE_INCLUDE_DIRS}")
        target_compile_options(epics::${_cas_lib} INTERFACE
                "${EPICS_BASE_CFLAGS_OTHER}")
    endforeach(_cas_lib)
    message("CAS LIBS = ${EPICS_BASE_CAS_LIBS}")

    foreach (_seq_lib IN LISTS _epics_seqlibs_libs_intl)
        message("Searching for ${_seq_lib} from ${_epics_seqlibs_libs_intl}")
        find_library("_concrete_seq_lib_${_seq_lib}" ${_seq_lib} HINTS ${EPICS_BASE_LIBRARY_DIRS})
        list(APPEND EPICS_BASE_SEQ_LIBS "${_concrete_seq_lib_${_seq_lib}}")

        if ("${_concrete_seq_lib_${_seq_lib}}" MATCHES ".*so")
            set(_concrete_seq_type_${_seq_lib} SHARED)
        else()
            set(_concrete_seq_type_${_seq_lib} STATIC)
        endif()

        add_library(epics::${_seq_lib} "${_concrete_seq_type_${_seq_lib}}" IMPORTED GLOBAL)
        set_property(TARGET epics::${_seq_lib} PROPERTY
                IMPORTED_LOCATION "${_concrete_seq_lib_${_seq_lib}}")
        target_include_directories(epics::${_seq_lib} INTERFACE
                "${EPICS_BASE_INCLUDE_DIRS}")
        target_compile_options(epics::${_seq_lib} INTERFACE
                "${EPICS_BASE_CFLAGS_OTHER}")
    endforeach(_seq_lib)
    message("SEQ LIBS = ${EPICS_BASE_SEQ_LIBS}")

    find_path(_epics_gdd_include gdd.h
            hints ${EPICS_BASE_INCLUDE_DIRS})
    find_library(_epics_gdd_lib gdd HINTS ${EPICS_BASE_LIBRARY_DIRS})


    if (_epics_gdd_include AND _epics_gdd_lib)

        if ("${_epics_gdd_lib}" MATCHES ".*so")
            set(_epics_gdd_type SHARED)
        else()
            set(_epics_gdd_type STATIC)
        endif()

        add_library(epics::gdd ${_epics_gdd_type} IMPORTED GLOBAL)
        set_property(TARGET epics::gdd PROPERTY
                IMPORTED_LOCATION "${_epics_gdd_lib}")
        target_include_directories(epics::gdd INTERFACE
                "${_epics_gdd_include}")
        target_compile_options(epics::gdd INTERFACE
                "${EPICS_BASE_CFLAGS_OTHER}")

    else (_epics_gdd_include AND _epics_gdd_lib)
        message("EPICS gdd library not found")
    endif (_epics_gdd_include AND _epics_gdd_lib)

    message("Found epics-base")
    message("version ${EPICS_BASE_VERSION}")
    message("libs ${EPICS_BASE_LIBRARIES}")
    message("lib dirs ${EPICS_BASE_LIBRARY_DIRS}")
    message("includes ${EPICS_BASE_INCLUDE_DIRS}")
    message("gdd includes ${_epics_gdd_include}")
    message("cflags ${EPICS_BASE_CFLAGS_OTHER}")
endif(EPICS_BASE_FOUND)
