from argparse import ArgumentParser
from jinja2 import Environment, FileSystemLoader
import os
import shutil

DEB_CODENAMES="stretch buster bullseye bookworm trixie".split()
STAGES="release testing production".split()

PROD_VERSION="5.5.0"

TEMPLATE_DIR="debian-template"
DEBIAN_DIR="debian"

PKG = "pkg"


def rename(fname:str, package_name: str) -> str:
    """
    Rename a file name orig.extension to package_name.extension
    :param fname:
    :return:
    """
    extension = fname.rsplit(".", 1)[-1]
    return f"{package_name}.{extension}"


if __name__ == "__main__":
    parser = ArgumentParser()
    parser.add_argument("codename", type=str,help="One of the allowable debian codenames", choices=DEB_CODENAMES)
    parser.add_argument("stage", type=str, choices=STAGES)
    args = parser.parse_args()

    env = Environment(loader=FileSystemLoader(TEMPLATE_DIR))

    shutil.rmtree(DEBIAN_DIR, ignore_errors=True)
    os.makedirs(DEBIAN_DIR, exist_ok=False)


    # setup context

    ## setup priorities

    package_name = f"cdssoft-{args.stage}-{args.codename}"

    context = {
        "package": package_name,
        "priority_testing" : "150",
        "priority_unstable" : "150",
        "priority_release": "500",
        "codename": args.codename,
        "stage": args.stage,
        "production_version": PROD_VERSION,
        "codenames": DEB_CODENAMES,
        "stages": STAGES,
    }

    if args.stage == "testing":
        context["priority_testing"] = "900"
    elif args.stage == "release":
        context["priority_release"] = "900"




    # render debian directory

    for root, _, files in os.walk(TEMPLATE_DIR):
        for filename in files:
            template_path = os.path.join(root, filename)
            rel_path = os.path.relpath(template_path, TEMPLATE_DIR)

            file_name = os.path.basename(rel_path)


            if file_name.startswith(f"{PKG}."):
                out_rel_path = rename(rel_path, package_name)
            else:
                out_rel_path = rel_path

            template = env.get_template(rel_path)

            out_path = os.path.join(DEBIAN_DIR, out_rel_path)

            basedir = os.path.dirname(out_path)
            os.makedirs(basedir, exist_ok=True)
            rendered_out = template.render(**context)

            with open(out_path, "w") as f:
                f.write(rendered_out)


    # render source templates
    env2 = Environment(loader=FileSystemLoader("."))

    files = [f for f in os.listdir() if f.endswith(".ja2")]

    for f in files:
        fname = f
        out_name = f[:-4]

        # get production specific templates
        if args.stage == "production":
            fname_prod = f + ".prod"
            if os.path.exists(fname_prod):
                fname = fname_prod

        template = env2.get_template(fname)
        rendered_out = template.render(**context)
        with open(out_name, "w") as f:
            f.write(rendered_out)