#
INCLUDE( CheckIncludeFiles )

SET(TMP_CMAKE_FIND_FRAMEWORK ${CMAKE_FIND_FRAMEWORK})
SET(CMAKE_FIND_FRAMEWORK "LAST")

#
# Obtain the include directory
#
MESSAGE( STATUS "DEBUG: PYTHON_EXECUTABLE: ${PYTHON_EXECUTABLE}" )
execute_process( COMMAND ${PYTHON_EXECUTABLE} -c "import numpy; print( numpy.get_include() );"
		 OUTPUT_VARIABLE TMP_INCLUDE_PATH
                 OUTPUT_STRIP_TRAILING_WHITESPACE )
FIND_PATH(PYTHON_NUMPY_INCLUDE_PATH "numpy/arrayobject.h"
	  PATHS ${TMP_INCLUDE_PATH} )

execute_process( COMMAND ${PYTHON_EXECUTABLE} -c "import numpy; print( numpy.__version__ );"
                 OUTPUT_VARIABLE PYTHON_NUMPY_VERSION
                 OUTPUT_STRIP_TRAILING_WHITESPACE )

SET(CMAKE_FIND_FRAMEWORK ${TMP_CMAKE_FIND_FRAMEWORK})
MESSAGE( STATUS "Numpy version: ${PYTHON_NUMPY_VERSION}" )
