# Simple PV

A wrapper around the pCas EPICS library to make it easy to express a reporting interface from a C or C++ program.

## CMake setup

This package requires the CDS CMake Modules to find the EPICS install.

An example CMakeLists.txt file to include simple_pv in your code would look like this:

<pre>
project(spv)
cmake_minimum_required(VERSION 3.18)

set(CMAKE_MODULE_PATH "/usr/share/cds-cmake/cmake/Modules;${CMAKE_MODULE_PATH}")
find_package(simple_pv)
find_package(EPICSBase REQUIRED)

add_executable(spv spv.cc)
target_link_libraries(spv PUBLIC simple_pv::simple_pv)
</pre>

## Interfaces

There are two interfaces, a simple C library.

<pre>
#include&lt;simple_pv/simple_pv.h&gt;
</pre>

And a C++ library

<pre>
#include&lt;simple_pv/simple_epics.hh&gt;
</pre>

The C library allows you to create an array of values describing your PVs with
a pointer to the data that will be updated.

The C++ library gives more control allowing the setup of read/write interfaces.
