#ifndef __SIMPLE_PV_CSTRING_HH__
#define __SIMPLE_PV_CSTRING_HH__

#include <simple_pv/simple_epics.hh>
namespace simple_epics
{
    /*!
     * @brief A description of a PV, used to describe a string PV to the server.
     * @note this is given a pointer to the data.  This value is only read
     * when a Server object is told to update its data.
     *
     * This version is used to support the clunky C api, do not use otherwise.
     */
    class pvCStringAttributes
    {
    public:
        pvCStringAttributes( std::string  pv_name,
                             ::StringPVIO io,
                             PVMode       mode = PVMode::ReadOnly )
            : name_{ std::move( pv_name ) }, mode_{ mode }, io_{ io }
        {
        }

        pvCStringAttributes( std::string pv_name, char* data );

        const std::string&
        name( ) const noexcept
        {
            return name_;
        }

        PVMode
        mode( ) const noexcept
        {
            return mode_;
        }

        const ::StringPVIO&
        io( ) const noexcept
        {
            return io_;
        }

    private:
        std::string  name_;
        PVMode       mode_;
        ::StringPVIO io_;
    };
} // namespace simple_epics

#endif