//
// Created by jonathan.hanks on 12/20/19.
//
#include <simple_pv/simple_epics.hh>

#include <atomic>
#include <cstdio>
#include <chrono>
#include <cmath>
#include <iostream>
#include <sstream>
#include <thread>

int
main( int argc, char** argv )
{
    const double pi = std::acos( -1 );

    std::atomic< int >    sin_val{ 0 };
    std::atomic< int >    cos_val{ 100 };
    std::atomic< double > sin_val_d{ 0.0 };
    std::atomic< double > cos_val_d{ 100.0 };
    std::atomic< int >    delay_ms{ 0 };
    std::atomic< int >    delete_signal{ 0 };

    simple_epics::pvStringData buffer1{ };
    simple_epics::pvStringData buffer2{ };
    buffer1.set( "Hello World!" );

    int                  i = 0;
    bool                 done = false;
    simple_epics::Server server{ "PV-TEST:" };
    server.addPV(
        simple_epics::pvIntAttributes( "TEST_SIN",
                                       &sin_val,
                                       std::make_pair( -200, 200 ),
                                       std::make_pair( -198, 198 ) ) );
    server.addPV(
        simple_epics::pvIntAttributes( "TEST_COS",
                                       &cos_val,
                                       std::make_pair( -200, 200 ),
                                       std::make_pair( -198, 198 ) ) );
    server.addPV(
        simple_epics::pvDoubleAttributes( "TEST_SIN_D",
                                          &sin_val_d,
                                          std::make_pair( -98.5, 98.5 ),
                                          std::make_pair( -85.5, 85.5 ) ) );
    server.addPV(
        simple_epics::pvDoubleAttributes( "TEST_COS_D",
                                          &cos_val_d,
                                          std::make_pair( -98.5, 98.5 ),
                                          std::make_pair( -85.5, 85.5 ) ) );
    server.addPV( simple_epics::pvIntAttributes( "TEST_DELAY",
                                                 &delay_ms,
                                                 std::make_pair( -1, 200 ),
                                                 std::make_pair( 0, 198 ) ) );
    server.addPV(
        simple_epics::pvIntAttributes( "DELETE_MSG_CHAN",
                                       &delete_signal,
                                       std::make_pair( -1, 2 ),
                                       std::make_pair( -1, 2 ),
                                       simple_epics::PVMode::ReadWrite ) );
    server.addPV( simple_epics::pvStringAttributes( "TEST_TEXT", &buffer1 ) );
    server.addPV( simple_epics::pvStringAttributes( "TEST_MSG", &buffer2 ) );

    std::cout << "pvs\n";
    auto pv_info = server.active_pvs( );
    for ( const auto& info : pv_info )
    {
        std::cout << info.name << std::endl;
    }

    while ( !done )
    {
        auto now = std::chrono::system_clock::now( );
        auto end_by = now + std::chrono::milliseconds( 1000 / 8 );

        double rad = ( pi * static_cast< double >( i ) ) / 180.0;

        sin_val = static_cast< int >( 100 * std::sin( rad ) );
        cos_val = static_cast< int >( 100 * std::cos( rad ) );

        sin_val_d = 100 * std::sin( rad );
        cos_val_d = 100 * std::cos( rad );

        i = ( i + 5 ) % 360;

        std::ostringstream os{ };
        os << i;
        buffer2.set( os.str( ) );

        server.update( );

        if ( delete_signal.load( ) != 0 )
        {
            std::cout << "Attempting to destroy TEST_MSG PV" << std::endl;
            std::cout << "\tsuccess = " << server.destroyPV( "TEST_MSG" )
                      << std::endl;
            delete_signal.store( 0 );
        }

        auto sleep_for =
            std::chrono::duration_cast< std::chrono::milliseconds >(
                end_by - std::chrono::system_clock::now( ) );
        if ( sleep_for.count( ) > 0 )
        {
            std::this_thread::sleep_for( sleep_for );
        }

        delay_ms = sleep_for.count( );
    }
    return 0;
}